<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\HostedNumbers;

use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class AuthorizationDocumentContext extends InstanceContext {
    /**
     * Initialize the AuthorizationDocumentContext
     * 
     * @param \Twilio\Version $version Version that contains the resource
     * @param string $sid AuthorizationDocument sid.
     * @return \Twilio\Rest\Preview\HostedNumbers\AuthorizationDocumentContext 
     */
    public function __construct(Version $version, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array(
            'sid' => $sid,
        );

        $this->uri = '/AuthorizationDocuments/' . rawurlencode($sid) . '';
    }

    /**
     * Fetch a AuthorizationDocumentInstance
     * 
     * @return AuthorizationDocumentInstance Fetched AuthorizationDocumentInstance
     */
    public function fetch() {
        $params = Values::of(array());

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new AuthorizationDocumentInstance(
            $this->version,
            $payload,
            $this->solution['sid']
        );
    }

    /**
     * Update the AuthorizationDocumentInstance
     * 
     * @param array|Options $options Optional Arguments
     * @return AuthorizationDocumentInstance Updated AuthorizationDocumentInstance
     */
    public function update($options = array()) {
        $options = new Values($options);

        $data = Values::of(array(
            'HostedNumberOrderSids' => $options['hostedNumberOrderSids'],
            'AddressSid' => $options['addressSid'],
            'Email' => $options['email'],
            'CcEmails' => $options['ccEmails'],
            'Status' => $options['status'],
        ));

        $payload = $this->version->update(
            'POST',
            $this->uri,
            array(),
            $data
        );

        return new AuthorizationDocumentInstance(
            $this->version,
            $payload,
            $this->solution['sid']
        );
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.HostedNumbers.AuthorizationDocumentContext ' . implode(' ', $context) . ']';
    }
}