<?php defined('BASEPATH') OR exit('No direct script access allowed');

// Framework routes
$route['default_controller'] = 'main';
$route['404_override'] = 'notify/error_404';
$route['translate_uri_dashes'] = TRUE;

// Shop routes
$route['shop'] = 'main';
$route['shop/search'] = 'shop/shop/search';
$route['shop/products'] = 'shop/shop/products';
$route['product/(:any)'] = 'shop/shop/product/$1';
$route['category/(:any)'] = 'shop/shop/products/$1';
$route['brand/(:any)'] = 'shop/shop/products/0/0/$1';
$route['category/(:any)/(:any)'] = 'shop/shop/products/$1/$2';

// Page route
$route['page/(:any)'] = 'shop/shop/page/$1';

// Cart routes
$route['cart'] = 'shop/cart_ajax';
$route['cart/(:any)'] = 'shop/cart_ajax/$1';
$route['cart/(:any)/(:any)'] = 'shop/cart_ajax/$1/$2';

// Misc routes
$route['shop/(:any)'] = 'shop/shop/$1';
$route['shop/(:any)/(:any)'] = 'shop/shop/$1/$2';
$route['shop/(:any)/(:any)/(:any)'] = 'shop/shop/$1/$2/$3';

// Auth routes
$route['login'] = 'main/login';
$route['logout'] = 'main/logout';
$route['profile'] = 'main/profile';
$route['register'] = 'main/register';
$route['login/(:any)'] = 'main/login/$1';
$route['logout/(:any)'] = 'main/logout/$1';
$route['profile/(:any)'] = 'main/profile/$1';
$route['forgot_password'] = 'main/forgot_password';
$route['activate/(:any)/(:any)'] = 'main/activate/$1/$2';
$route['reset_password/(:any)'] = 'main/reset_password/$1';

// Admin area routes
$route['admin'] = 'admin/welcome';
$route['admin/users'] = 'admin/auth/users';
$route['admin/users/create_user'] = 'admin/auth/create_user';
$route['admin/users/profile/(:num)'] = 'admin/auth/profile/$1';
$route['admin/login'] = 'admin/auth/login';
$route['admin/login/(:any)'] = 'admin/auth/login/$1';
$route['admin/logout'] = 'admin/auth/logout';
$route['admin/logout/(:any)'] = 'admin/auth/logout/$1';
// $route['admin/register'] = 'admin/auth/register';
$route['admin/forgot_password'] = 'admin/auth/forgot_password';
$route['admin/sales/(:num)'] = 'admin/sales/index/$1';
$route['admin/products/(:num)'] = 'admin/products/index/$1';
$route['admin/purchases/(:num)'] = 'admin/purchases/index/$1';
$route['admin/quotes/(:num)'] = 'admin/quotes/index/$1';

//Api for get, put and post
$route['report']='example/reportrview';
$route['test']				='example/test';
$route['user']				='example/user';
$route['productview']			='example/productview';
$route['brandview']			='example/brandview';
$route['categoriesview']		='example/categoriesview';
$route['companiesview']			='example/companiesview';
$route['companiescreditview']			='example/companiescreditview';
$route['companiesupdate']		='example/companiesupdate';
$route['paymentsview']			='example/paymentsview';
$route['suspend']			='example/suspend';
$route['suspendsaleview']		='example/suspendView';
$route['addcustomer']			='example/addcustomer';
$route['customer_group']		='example/customergroup';
$route['price_group']			='example/pricegroup';
$route['view_receipt']			='example/viewreceipt';
$route['view_receipts']			='example/viewreceipts';
$route['tax_rates']			='example/taxrates';
$route['units']				='example/units';
$route['warehouse']			='example/warehouse';
$route['loginn']				='example/login';
$route['partial_payment']		='example/partial';
$route['full_payment']			='example/full';
$route['payments']			='example/paymentssale';
$route['registers']			='example/registers';
$route['open_registers']		='example/openregister';
$route['register_details']		='example/registerdetails';
$route['close_register']		='example/closeregister';
$route['add_payments']			='example/addpayments';
$route['sale_edit']			='example/saleedit';
$route['return_sale']			='example/returnsale';
$route['print']				='example/view';
$route['biller_view']			='example/billerview';
$route['logout']			='example/logout';
$route['edit_payment']			='example/editpayment';
$route['reference']			='example/reference';
$route['session']			='example/session';
$route['register_open']			='example/registeropen';
$route['search']			='example/search';
$route['sale_search']			='example/saleview';
$route['map']			='example/map';
$route['credit']			='example/viewCredit';
$route['offline']			='example/offline';
$route['credits']			='example/viewCredits';
$route['paid_by_customer']='example/addpaymentAgainstCustomer';