# SwaggerClient-php

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 4.0.0
- Package version: v0.0.1
- Build date: 2018-05-16T00:56:54.871+01:00
- Build package: class io.swagger.codegen.languages.PhpClientCodegen

## Requirements

PHP 5.4.0 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/smsgatewayme/client-php.git"
    }
  ],
  "require": {
    "smsgatewayme/client": "^0.0.1"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/SwaggerClient-php/autoload.php');
```

## Tests 

To run the unit tests:

```
composer install
./vendor/bin/phpunit lib/Tests
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure API key authorization: Authorization
SMSGatewayMe\Client\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. BEARER) for API key, if needed
// SMSGatewayMe\Client\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'BEARER');

$api_instance = new SMSGatewayMe\Client\Api\CallbackApi();
$callback = new \SMSGatewayMe\Client\Model\CreateCallbackRequest(); // \SMSGatewayMe\Client\Model\CreateCallbackRequest | callback to create

try {
    $result = $api_instance->createCallback($callback);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CallbackApi->createCallback: ', $e->getMessage(), "\n";
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://smsgateway.me/api/v4*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CallbackApi* | [**createCallback**](docs/CallbackApi.md#createcallback) | **POST** /callback | Create Callback
*CallbackApi* | [**getCallback**](docs/CallbackApi.md#getcallback) | **GET** /callback/{id} | Get a specific callback
*CallbackApi* | [**searchCallbacks**](docs/CallbackApi.md#searchcallbacks) | **POST** /callback/search | Search callbacks
*CallbackApi* | [**updateCallback**](docs/CallbackApi.md#updatecallback) | **PUT** /callback/{id} | Update callback
*ContactApi* | [**addPhoneNumber**](docs/ContactApi.md#addphonenumber) | **PUT** /contact/{id}/phone-number/{phone-number} | The phone number to add
*ContactApi* | [**createContacts**](docs/ContactApi.md#createcontacts) | **POST** /contact | Create Contacts
*ContactApi* | [**deletePhoneNumber**](docs/ContactApi.md#deletephonenumber) | **DELETE** /contact/{id}/phone-number/{phone-number} | The phone number to delete
*ContactApi* | [**getContact**](docs/ContactApi.md#getcontact) | **GET** /contact/{id} | Get a specific contact
*ContactApi* | [**searchContacts**](docs/ContactApi.md#searchcontacts) | **POST** /contact/search | Search contacts
*ContactApi* | [**updateContact**](docs/ContactApi.md#updatecontact) | **PUT** /contact/{id} | Update contact
*DeviceApi* | [**getDevice**](docs/DeviceApi.md#getdevice) | **GET** /device/{id} | Get a specific device
*DeviceApi* | [**searchDevices**](docs/DeviceApi.md#searchdevices) | **POST** /device/search | Search devices
*MessageApi* | [**cancelMessages**](docs/MessageApi.md#cancelmessages) | **POST** /message/cancel | Cancel messages
*MessageApi* | [**getMessage**](docs/MessageApi.md#getmessage) | **GET** /message/{id} | Get a specific message
*MessageApi* | [**searchMessages**](docs/MessageApi.md#searchmessages) | **POST** /message/search | Search messages
*MessageApi* | [**sendMessages**](docs/MessageApi.md#sendmessages) | **POST** /message/send | Send messages


## Documentation For Models

 - [Callback](docs/Callback.md)
 - [CallbackSearchResult](docs/CallbackSearchResult.md)
 - [CancelMessageRequest](docs/CancelMessageRequest.md)
 - [Contact](docs/Contact.md)
 - [ContactSearchResult](docs/ContactSearchResult.md)
 - [CreateCallbackRequest](docs/CreateCallbackRequest.md)
 - [CreateContactRequest](docs/CreateContactRequest.md)
 - [Device](docs/Device.md)
 - [DeviceAttributes](docs/DeviceAttributes.md)
 - [DeviceSearchResult](docs/DeviceSearchResult.md)
 - [Error](docs/Error.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [FatalResponse](docs/FatalResponse.md)
 - [Message](docs/Message.md)
 - [MessageLog](docs/MessageLog.md)
 - [MessageSearchResult](docs/MessageSearchResult.md)
 - [Search](docs/Search.md)
 - [SearchFilter](docs/SearchFilter.md)
 - [SearchOrderBy](docs/SearchOrderBy.md)
 - [SendMessageRequest](docs/SendMessageRequest.md)
 - [UpdateCallbackRequest](docs/UpdateCallbackRequest.md)
 - [UpdateContactRequest](docs/UpdateContactRequest.md)


## Documentation For Authorization


## Authorization

- **Type**: API key 
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




