<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareThreatState File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* WindowsMalwareThreatState class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareThreatState extends Enum
{
    /**
    * The Enum WindowsMalwareThreatState
    */
    const ACTIVE = "active";
    const ACTION_FAILED = "actionFailed";
    const MANUAL_STEPS_REQUIRED = "manualStepsRequired";
    const FULL_SCAN_REQUIRED = "fullScanRequired";
    const REBOOT_REQUIRED = "rebootRequired";
    const REMEDIATED_WITH_NON_CRITICAL_FAILURES = "remediatedWithNonCriticalFailures";
    const QUARANTINED = "quarantined";
    const REMOVED = "removed";
    const CLEANED = "cleaned";
    const ALLOWED = "allowed";
    const NO_STATUS_CLEARED = "noStatusCleared";
}
