<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Transaction_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

	public function addTransaction($data,$sale)
    { 
		
		$data['sale_id'] = $sale;
		if ($this->db->insert('transaction', $data))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
    
    public function addExpenseTransaction($expense_data)
    { 
		
		
		if ($this->db->insert('expenses', $expense_data))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
    
    
	public function addTransa($data)
    { //print_r($data);die();
        $edata= array(
           'date' => $data['date'],
                'reference' => $this->site->getReference('ex'),
                'grand_total' => $data['amount'],
                'product_tax' => $data['vat'],
                'created_by' => $this->session->userdata('user_id'),
                'note' =>$data['note'],
                'category_id' => $data['category'],
                'warehouse_id' =>$data['warehouse_id']
            );
           //print_r($edata);die(); 
		if ($this->db->insert('transaction', $data))
		{
		    $transaction_id = $this->db->insert_id();
		    if ($this->db->insert('expenses', $edata)) 
		    {
                if ($this->site->getReference('ex') == $edata['reference']) 
                {
                $this->site->updateReference('ex');
                }
		    }
			return true;
        }
        return FALSE;
    }
	
	public function addTransaction_Purchase($data,$sale)
    { 
		$data['purchase_id'] = $sale;
		if ($this->db->insert('transaction', $data))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	
	public function updateSale($id,$data)
    { 
		if ($this->db->update('transaction', $data, array('sale_id' => $id)))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	
	public function updatePurchase($id,$data)
    { 
		if ($this->db->update('transaction', $data, array('purchase_id' => $id)))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	
	public function getAllTransaction()
    {
        $q = $this->db->get('transaction');
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    	public function getAllTransaction_bystart($start_date)
    {
        $this->db
                ->select('*')
                 ->from('transaction');
         if ($start_date) {
                $this->db->where('DATE_FORMAT(date,"%Y-%m-%d")', $start_date);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransaction_byto($to_date)
    {
        $this->db
                ->select('*')
                 ->from('transaction');
         if ($to_date) {
                $this->db->where('DATE_FORMAT(pay_date,"%Y-%m-%d")', $to_date);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransaction_bydate($start_date,$to_date)
    {
        $this->db
                ->select('*')
                 ->from('transaction');
         if ($start_date && $to_date) {
               
                $this->db->where('DATE_FORMAT(date,"%Y-%m-%d") >=', $start_date);
                $this->db->where('DATE_FORMAT(pay_date,"%Y-%m-%d") <=', $to_date);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
	public function getAllTransactions($warehouse,$start_date, $end_date)
    {
         $this->db
                ->select('*')
                 ->from('transaction');
         if ($warehouse) {
                $this->db->where('warehouse_id', $warehouse);
            }
             if ($start_date) {
                $this->db->where($this->db->dbprefix('transaction').'.date BETWEEN "' . $start_date . '" and "' . $end_date . '"');
            }
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
	
	public function getAllTransactionByID($id)
    {
		$q = $this->db->get_where('transaction', array('id' => $id), 1);
		if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }
	
	
	public function deleteTransaction($id)
    {
        if ($this->db->delete('transaction', array('id' => $id))) 
		{
            /*$this->db->delete('transaction', array('product_id' => $id));
            $this->db->delete('product_variants', array('product_id' => $id));
            $this->db->delete('product_photos', array('product_id' => $id));
            $this->db->delete('product_prices', array('product_id' => $id));*/
            return true;
        }
        return FALSE;
    }
	
	public function addAccount($data)
    {
        if ($this->db->insert('accounts', $data)) 
		{
            $account_id = $this->db->insert_id();

			return true;
        }
        return false;

    }
	public function getAllAccount()
    {
        $q = $this->db->get('accounts');
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				
                $data[] = $row;
            
			}
			return $data;
        }
        return FALSE;
    }
	
	public function getAllAccounts()
    {
        $q = $this->db->get('accounts');
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				if(($row->account_category ==2)||($row->account_category==6))
				{
					$data[] = $row;
				}
			}
			return $data;
        }
        return FALSE;
    }
	
	public function getAllCateType() 
	{
        $q = $this->db->get("accounts");
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				if(($row->belongs_to ==1)||($row->belongs_to==3))
				{
					$data[] = $row;
				}
			}
            return $data;
        }
        return FALSE;
    }
    
    public function getAllCategoryType() 
	{
        $q = $this->db->get('sma_categories');
		
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row)
			{
                $data[] = $row;
            } 
			return $data;
        }
        return FALSE;
    }
    
	public function getCateType() 
	{
        $q = $this->db->get("accounts");
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				if(($row->belongs_to ==2)||($row->belongs_to==3))
				{
					$data[] = $row;
				}
			}
            return $data;
        }
        return FALSE;
    }
	
	public function updateAccount($id,$data)
    {
        if ($this->db->update('accounts', $data, array('id' => $id))) 
		{
            $account_ids = $this->db->insert_id();

			return true;
        }
        return false;

    }
	
	public function getAllAccountByID($id) 
	{
        $q = $this->db->get_where('accounts', array('id' => $id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }
	
	public function getAllAccountByType($types) 
	{
		$q = $this->db->get_where('accounts', array('type' => $types), 1);
		if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
		
        return FALSE;
    }
	
	public function deleteAccount($id)
    {
        if ($this->db->delete('accounts', array('id' => $id))) {
            /*$this->db->delete('transaction', array('product_id' => $id));
            $this->db->delete('product_variants', array('product_id' => $id));
            $this->db->delete('product_photos', array('product_id' => $id));
            $this->db->delete('product_prices', array('product_id' => $id));*/
            return true;
        }
        return FALSE;
    }
	
	
	public function addStatement($start_date,$end_date,$Account) 
	{ 
		$this->db->where("date <=", $end_date);
        $this->db->where("date >=", $start_date);
		$this->db->where("account", $Account);
		$q = $this->db->get('transaction');
		if ($q->num_rows() > 0) 
		{
           foreach (($q->result()) as $row) 
		   {
                $data[] = $row;
           }
           return $data;
        }
        return array();
    }
 public function getTrandByName($name)
    {
        $q = $this->db->get_where('type', array('name' => $name), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function addType($data)
    {
        if ($this->db->insert("type", $data)) 
		{
            return true;
        }
        return false;
    }

    public function addTypes($data)
    {
        if ($this->db->insert_batch('type', $data)) 
		{
            return true;
        }
        return false;
    }

    public function updateType($id, $data = array())
    {
        if ($this->db->update("type", $data, array('id' => $id))) 
		{
            return true;
        }
        return false;
    }

    public function typeHasTransaction($brand_id)
    {
        $q = $this->db->get_where('transaction', array('type' => $type_id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function deleteType($id)
    {
        if ($this->db->delete("type", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
	
	public function getTransactionCategoryByID($id)
    {
        $q = $this->db->get_where("transaction_categories", array('id' => $id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function getTransactionCategoryByCode($code)
    {
        $q = $this->db->get_where("transaction_categories", array('code' => $code), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function addTransactionCategory($data)
    {
        if ($this->db->insert("transaction_categories", $data)) 
		{
            return true;
        }
        return false;
    }

    public function addTransactionCategories($data)
    {
        if ($this->db->insert_batch("transaction_categories", $data)) 
		{
            return true;
        }
        return false;
    }

    public function updateTransactionCategory($id, $data = array())
    {
        if ($this->db->update("transaction_categories", $data, array('id' => $id))) 
		{
            return true;
        }
        return false;
    }

    public function hasTransactionCategoryRecord($id)
    {
        $this->db->where('id', $id);
        return $this->db->count_all_results('transaction');
    }

    public function deleteTransactionCategory($id)
    {
        if ($this->db->delete("transaction_categories", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
	public function deleteCategory($id)
    {
        if ($this->db->delete("transaction_categories", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
	public function getAccountCategoryByName($name)
    {
        $q = $this->db->get_where('account_category', array('name' => $name), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function addAccountCategory($data)
    {
        if ($this->db->insert("account_category", $data)) 
		{
            return true;
        }
        return false;
    }

    public function addAccountCategories($data)
    {
        if ($this->db->insert_batch('type', $data)) 
		{
            return true;
        }
        return false;
    }

    public function updateAccountCategory($id, $data = array())
    {
        if ($this->db->update("account_category", $data, array('id' => $id))) 
		{
            return true;
        }
        return false;
    }

    public function AccountCategoryHasTransaction($brand_id)
    {
        $q = $this->db->get_where('transaction', array('account_category' => $account_category_id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function deleteAccountCategory($id)
    {
        if ($this->db->delete("account_category", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
  public function getAllAccountCategory()
    {
        $q = $this->db->get('account_category');
		
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row)
			{
                $data[] = $row;
            } 
			return $data;
        }
        return FALSE;
    }
     public function getCompanyByID() {
      $q = $this->db->get_where('companies', array('group_name' => 'customer'));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
     public function getCompaniesByID() {
      $q = $this->db->get_where('companies', array('group_name' => 'supplier'));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function TotalSale($cust) {
      $q = $this->db->get_where('sales', array('`customer_id' => $cust));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
 public function addCustomer($data,$cdata,$cust_type,$cat_id)
{
    if($cust_type=='deposit')
    {
        $prev_amnts = $this->db->get_where('companies',array('id' => $data['company_id'],))->row()->deposit_amount;
        $previs_amnts = 0-($prev_amnts);
        
        if ($this->db->insert('deposits', $data)) 
        {
            
            $this->db->select('*')
                     ->from('transaction')
                     ->where('customer_id',$data['company_id'])
                     ->where('category_id',$cat_id)
                     ->where('type=','previous balance');

                     $open_balance = $this->db->get();
                   
                if($open_balance->num_rows() > 0 )
                {   
                    
                    $payment['reference_no'] 	= $this->site->getReference('pay');
                    $open_pay_status = !empty($open_balance->result()[0]->payment_status)?$open_balance->result()[0]->payment_status:'' ;
                   //print_r($open_balance->result());die();
                    if($open_pay_status !='paid')
                    { 
                        //echo"1";die();
                        //print_r($data['amount']);die();
                        if($previs_amnts == $data['amount'])
                        {
                            //echo"1";die();
                            $dep_amnts      = $prev_amnts;//$this->db->get_where('companies',array('id' => $data['company_id']))->row()->deposit_amount;
                            $warehouses     = $this->db->get_where('companies',array('id' => $data['company_id']))->row()->warehouse_id;
                            $paid_amount	= $dep_amnts + $data['amount'];
                            $transt =array
                             (
                                 'type'             	=> 'income',
                                 'account'          	=> '5',
                                 'category'         	=> '8',
                                 'date'              	=> $data['date'],
                                 'pay_date'             => $data['pay_date'],
                                 'amount'            	=> $data['amount'],
                                 'note'              	=> '',
                                 'description'       	=> 'Sale',
                                 'acc_type'          	=> '18',
                                 'deposit_withdrawal' 	=>  'deposit',
                                 'sale_id' 				=>  '',
                                 'warehouse_id'			=>  $warehouses,
                                 'customer_id'          =>  $data['company_id'],
                                 'category_id'          =>  $data['category_id'],
                                 'voucher'              =>  $data['voucher'],
                                 'payment_status'        => "paid"
                              );
                             $paymentt = array
                             (
                                 'date' 		=> $data['date'],
                                 'reference_no' => $payment['reference_no'],
                                 'amount' 		=> $data['amount'],
                                 'paid_by' 		=> $data['paid_by'],
                                 'cheque_no' 	=> '',
                                 'cc_no' 		=> '',
                                 'cc_holder' 	=> '',
                                 'cc_month' 	=> '',
                                 'cc_year' 		=> '',
                                 'cc_type' 		=> '',
                                 'created_by' 	=> $data['created_by'],
                                 'note' 		=> '',
                                 'type' 		=> 'received',
                                 'sale_id' 		=>''
                             );//print_r($payment);die();
                             $dat = array
                             (
                                 'deposit_amount'			=>$paid_amount,
                                 
                             );
                              $trans_update = array(
                                    'payment_status'=>'paid'
                                    
                                    );
                             if($this->db->update('companies', $dat, array('id' =>$data['company_id'])) &&  $this->db->insert('transaction', $transt) &&$this->db->insert('payments', $paymentt) )
                             {
                                $this->db->update('transaction', $trans_update, array('id' =>$open_balance->result()[0]->id));
                                 //print_r($trans);die();
                                 $this->site->updateReference('pay');
                                 //return true; 
                             }
                        }
                        
                         elseif($previs_amnts < $data['amount'])
                        {
                            //echo"2";die();
                             $dep_amnts     = $previs_amnts;//$this->db->get_where('companies',array('id' => $data['company_id']))->row()->deposit_amount;
                             $warehouses    = $this->db->get_where('companies',array('id' => $data['company_id']))->row()->warehouse_id;
                             $paid_amount	= $previs_amnts - $data['amount'];
                            
                            if($paid_amount >'0')
                            {
                                //echo"1";die();
                                //$data['amount']				= $data['amount'] - $previs_amnts; 
                                $transt_1 =array
                                (
                                    'type'             		=> 'income',
                                    'account'          		=> '5',
                                    'category'         		=> '8',
                                    'date'              	=> $data['date'],
                                    'pay_date'              => $data['pay_date'],
                                    'amount'            	=> $previs_amnts,
                                    'note'              	=> '',
                                    'description'       	=> 'Sale',
                                    'acc_type'          	=> '18',
                                    'deposit_withdrawal' 	=> 'deposit',
                                    'sale_id' 				=> '',
                                    'warehouse_id'			=> $warehouses,
                                    'customer_id'           => $data['company_id'],
                                    'category_id'           => $data['category_id'],
                                    'voucher'               => $data['voucher'],
                                    'payment_status'        => "paid"
                                );
                                 $trans_update_1 = array(
                                    'payment_status'=>'paid'
                                    
                                    );
                                $paymentt_1 = array
                                (
                                    'date' 			=> $data['date'],
                                    'reference_no' 	=> $payment['reference_no'],
                                    'amount' 		=> $previs_amnts,
                                    'paid_by' 		=> $data['paid_by'],
                                    'cheque_no' 	=> '',
                                    'cc_no' 		=> '',
                                    'cc_holder' 	=> '',
                                    'cc_month' 		=> '',
                                    'cc_year' 		=> '',
                                    'cc_type' 		=> '',
                                    'created_by' 	=> $data['created_by'],
                                    'note' 			=> '',
                                    'type' 			=> 'received',
                                    'sale_id' 		=>''
                                );//print_r($payment);die();
                                $dat_1 = array
                                (
                                    'deposit_amount'			=>'0',
                                 
                                );
                                if($this->db->update('companies', $dat_1, array('id' =>$data['company_id'])) &&  $this->db->insert('transaction', $transt_1) &&$this->db->insert('payments', $paymentt_1) )
                                {
                                    $this->db->update('transaction', $trans_update_1, array('id' =>$open_balance->result()[0]->id));
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                                
                            }
                            elseif ($paid_amount =='0') 
                            {
                               // echo"2";die();
                                //$data['amount']				= $data['amount'] - $previs_amnts;
                                $transt_2 =array
                                (
                                    'type'             		=> 'income',
                                    'account'          		=> '5',
                                    'category'         		=> '8',
                                    'date'              	=> $data['date'],
                                    'pay_date'              => $data['pay_date'],
                                    'amount'            	=> $data['amount'],
                                    'note'              	=> '',
                                    'description'       	=> 'Sale',
                                    'acc_type'          	=> '18',
                                    'deposit_withdrawal' 	=> 'deposit',
                                    'sale_id' 				=> '',
                                    'warehouse_id'			=> $warehouses,
                                    'customer_id'           => $data['company_id'],
                                    'category_id'           => $data['category_id'],
                                    'voucher'               => $data['voucher'],
                                    'payment_status'        => "paid"
                                );
                                $trans_update_2 = array(
                                    'payment_status'=>'paid'
                                    
                                    );
                                $paymentt_2 = array
                                (
                                    'date' 			=> $data['date'],
                                    'reference_no' 	=> $payment['reference_no'],
                                    'amount' 		=> $data['amount'],
                                    'paid_by' 		=> $data['paid_by'],
                                    'cheque_no' 	=> '',
                                    'cc_no' 		=> '',
                                    'cc_holder' 	=> '',
                                    'cc_month' 		=> '',
                                    'cc_year' 		=> '',
                                    'cc_type' 		=> '',
                                    'created_by' 	=> $data['created_by'],
                                    'note' 			=> '',
                                    'type' 			=> 'received',
                                    'sale_id' 		=>''
                                );//print_r($payment);die();
                                $dat_2 = array
                                (
                                    'deposit_amount'			=>'0',
                                 
                                );
                                if($this->db->update('companies', $dat_2, array('id' =>$data['company_id'])) &&  $this->db->insert('transaction', $transt_2) &&$this->db->insert('payments', $paymentt_2) )
                                {
                                    $this->db->update('transaction', $trans_update_2, array('id' =>$open_balance->result()[0]->id));
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                            }

                            elseif($paid_amount < 0)
                            {
                                //echo"3";die();
                    
                                $transt_3 =array
                                            (
                                                'type'             		=> 'income',
                                                'account'          		=> '5',
                                                'category'         		=> '8',
                                                'date'              	=> $data['date'],
                                                'pay_date'              => $data['pay_date'],
                                                'amount'            	=> $previs_amnts,
                                                'note'              	=> '',
                                                'description'       	=> 'Sale',
                                                'acc_type'          	=> '18',
                                                'deposit_withdrawal' 	=> 'deposit',
                                                'sale_id' 				=> "",
                                                'warehouse_id'			=> $warehouses,
                                                'customer_id'           => $data['company_id'],
                                                'category_id'           => $data['category_id'],
                                                'voucher'              => $data['voucher'],
                                                'payment_status'        => "pending"
                                            );
                                $paymentt_3 = array
                                (
                                    'date' 			=> $data['date'],
                                    'reference_no' 	=> $payment['reference_no'],
                                    'amount' 		=> $previs_amnts,
                                    'paid_by' 		=> $data['paid_by'],
                                    'cheque_no' 	=> '',
                                    'cc_no' 		=> '',
                                    'cc_holder' 	=> '',
                                    'cc_month' 		=> '',
                                    'cc_year' 		=> '',
                                    'cc_type' 		=> '',
                                    'created_by' 	=> $data['created_by'],
                                    'note' 			=> '',
                                    'type' 			=> 'received',
                                    'sale_id' 		=>''
                                );//print_r($payment);die();
                                 $dat_3 = array
                                (
                                    'deposit_amount'			=>'0',
                                 
                                );
                                $trans_update_3 = array(
                                    'payment_status'=>'paid'
                                    
                                    );
                                // $data['amount'] = $data['amount'] - $previs_amnts;
                                   // print_r($data['amount']);die();
                                if($this->db->update('companies', $dat_3, array('id' =>$data['company_id'])) &&  $this->db->insert('transaction', $transt_3) &&$this->db->insert('payments', $paymentt_3) )
                                {
                                    $this->db->update('transaction', $trans_update_3, array('id' =>$open_balance->result()[0]->id));
                                   // die("test");
                                    $this->site->updateReference('pay');
                                   
                                    $this->db
                                    ->select('*')
                                    ->from('sales')
                                    ->where('customer_id',$data['company_id'])
                                    ->where("(payment_status='pending' OR payment_status='due')", NULL, FALSE)
                                    ->order_by("id", "asc"); 
                                    $sale = $this->db->get();
                         
                                    if($sale->num_rows() > 0)
                                    {
                 
                                       foreach($sale->result() as $row)
                                        {
                                            
                                                if($data['amount'] !=0)
                                                    {
                                                        $paid 			=$row->paid ? $row->paid:'0';
                                                        $grandtotal 	= $row->grand_total;//print_r($payment_status);
                                                       
                                                        if($grandtotal == $data['amount'])
                                                        {
                                                            $balance 					= $grandtotal - $paid;
                                                            $payment_status 			= 'paid';
                                                            $sale_status 				= 'completed';
                                                            $paid 						= $paid +  $balance;
                                                            $data['amount']				= $data['amount'] - $balance;
                                                            $payment['reference_no'] 	= $this->site->getReference('pay');
                                                            $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                                            $transt_4 =array
                                                            (
                                                                'type'             		=> 'income',
                                                                'account'          		=> '5',
                                                                'category'         		=> '8',
                                                                'date'              	=> $data['date'],
                                                                'pay_date'              => $data['pay_date'],
                                                                'amount'            	=> $balance,
                                                                'note'              	=> '',
                                                                'description'       	=> 'Sale',
                                                                'acc_type'          	=> '18',
                                                                'deposit_withdrawal' 	=> 'deposit',
                                                                'sale_id' 				=> $row->id,
                                                                'warehouse_id'			=> $warehouse_id,
                                                                'customer_id'           => $data['company_id'],
                                                                'category_id'           => $data['category_id'],
                                                                'voucher'              => $data['voucher'],
                                                            );
                                                            $paymentt_4 = array
                                                            (
                                                                'date' 			=> $data['date'],
                                                                'reference_no' 	=> $payment['reference_no'],
                                                                'amount' 		=>  $balance,
                                                                'paid_by' 		=> $data['paid_by'],
                                                                'cheque_no' 	=> '',
                                                                'cc_no' 		=> '',
                                                                'cc_holder' 	=> '',
                                                                'cc_month' 		=> '',
                                                                'cc_year' 		=> '',
                                                                'cc_type' 		=> '',
                                                                'created_by' 	=> $data['created_by'],
                                                                'note' 			=> '',
                                                                'type' 			=> 'received',
                                                                'sale_id' 		=> $row->id
                                                            );//print_r($payment);die();
                                                            $dat_4 = array
                                                            (
                                                                'paid'			=>$paid,
                                                                'sale_status'	=> $sale_status,
                                                                'payment_status'=> $payment_status
                                                            );
                                                            if($this->db->update('sales', $dat_4, array('id' => $row->id)) &&  $this->db->insert('transaction', $transt_4) &&$this->db->insert('payments', $paymentt_4) )
                                                            {
                                                        
                                                                //print_r($trans);die();
                                                                $this->site->updateReference('pay');
                                                                //return true;
                                                            }
                                                        } 
                                                        elseif($data['amount'] > $grandtotal)
                                                        {
                                                    
                                                
                                                            $payment_status 			= 'paid';
                                                            $sale_status 				= 'completed';
                                                            $balance_1 					= $grandtotal - $paid;	
                                                            $paid 						= $paid +  $balance_1;
                                                            
                                                            $payment['reference_no'] 	= $this->site->getReference('pay');
                                                            $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                                            $darr_18 =array
                                                            (
                                                                'paid'				=> $paid,
                                                                'sale_status'		=> $sale_status,
                                                                'payment_status'	=> $payment_status
                                                            );	
                                                            $transrr_18 =array
                                                            (
                                                                'type'             	=> 'income',
                                                                'account'          	=> '5',
                                                                'category'         	=> '8',
                                                                'date'              => $data['date'],
                                                                'pay_date'              => $data['pay_date'],
                                                                'amount'            => $balance_1,
                                                                'note'              => '',
                                                                'description'       => 'Sale',
                                                                'acc_type'          =>  '18',
                                                                'deposit_withdrawal'=> 'deposit',
                                                                'sale_id' 			=> $row->id,
                                                                'warehouse_id'		=> $warehouse_id,
                                                                'customer_id'           => $data['company_id'],
                                                                'category_id'           => $data['category_id'], 
                                                                'voucher'              => $data['voucher']
                                                            );
                                                            $paymentrr_18 = array
                                                            (
                                                                'date' 			=> $data['date'],
                                                                'reference_no' 	=> $payment['reference_no'],
                                                                'amount' 		=> $balance_1,
                                                                'paid_by' 		=> $data['paid_by'],
                                                                'cheque_no' 	=> '',
                                                                'cc_no' 		=> '',
                                                                'cc_holder' 	=> '',
                                                                'cc_month' 		=> '',
                                                                'cc_year' 		=> '',
                                                                'cc_type' 		=> '',
                                                                'created_by' 	=> $data['created_by'],
                                                                'note' 			=> '',
                                                                'type' 			=> 'received',
                                                                'sale_id' 		=> $row->id
                                                        
                                                            );
                                                            $data['amount']				= $data['amount'] - $balance_1;
                                                            if($this->db->update('sales', $darr_18, array('id' => $row->id)) &&  $this->db->insert('transaction', $transrr_18) && $this->db->insert('payments', $paymentrr_18) )
                                                            {
                                                        
                                                                //print_r($trans);die();
                                                                $this->site->updateReference('pay');
                                                                //return true;
                                                            }
                                                        } 
                                                        elseif($data['amount'] < $grandtotal)
                                                        {
                                                            $paid 			=$row->paid ? $row->paid:'0';
                                                            $grandtotal 	= $row->grand_total;
                                                            $balance_2 = $grandtotal - $paid;
                                                            if($data['amount'] == $balance_2)
                                                            {
                                                                $payment_status 		= 'paid';
                                                                $sale_status 			= 'completed';
                                                                $paid 					= $paid + $data['amount'];
                                                                $data['amount']			=  0;
                                                                $payment['reference_no']= $this->site->getReference('pay');
                                                                $warehouse_id 			= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                                                $das_19 =array
                                                                (
                                                                    'paid'				=> $paid,
                                                                    'sale_status'		=> $sale_status,
                                                                    'payment_status'	=> 'paid'
                                                                );
                                                                $transs_19 =array
                                                                (
                                                                    'type'             	=> 'income',
                                                                    'account'          	=> '5',
                                                                    'category'         	=> '8',
                                                                    'date'              => $data['date'],
                                                                    'pay_date'              => $data['pay_date'],
                                                                    'amount'            => $balance_2,
                                                                    'note'              => '',
                                                                    'description'       => 'Sale',
                                                                    'acc_type'          => '18',
                                                                    'deposit_withdrawal'=> 'deposit',
                                                                    'sale_id' 			=> $row->id,
                                                                    'warehouse_id'		=> $warehouse_id,
                                                                    'customer_id'           => $data['company_id'],
                                                                    'category_id'           => $data['category_id'],
                                                                    'voucher'              => $data['voucher']
                                                                );
                                                                $payments_19 = array
                                                                (
                                                                    'date' 			=> $data['date'],
                                                                    'reference_no' 	=> $payment['reference_no'],
                                                                    'amount' 		=> $balance_2,
                                                                    'paid_by' 		=> $data['paid_by'],
                                                                    'cheque_no' 	=> '',
                                                                    'cc_no' 		=> '',
                                                                    'cc_holder' 	=> '',
                                                                    'cc_month' 		=> '',
                                                                    'cc_year' 		=> '',
                                                                    'cc_type' 		=> '',
                                                                    'created_by' 	=> $data['created_by'],
                                                                    'note' 			=> '',
                                                                    'type' 			=> 'received',
                                                                    'sale_id' 		=> $row->id
                                                                );
                                                                if($this->db->update('sales', $das_19, array('id' => $row->id)) &&  $this->db->insert('transaction', $transs_19) && $this->db->insert('payments', $payments_19) )
                                                                    {
                                                                
                                                                        //print_r($trans);die();
                                                                        $this->site->updateReference('pay');
                                                                        //return true;
                                                                    }
                                                            } 
                                                            elseif($data['amount'] < $balance_2)
                                                            {
                                                                $payment_status 			= 'paid';
                                                                $sale_status 				= 'completed';
                                                                $paid 						= $paid + $data['amount'];
                                                                $data['amount']				=  0;
                                                                $payment['reference_no'] 	= $this->site->getReference('pay');
                                                                $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                                                $daq_20 =array
                                                                (
                                                                'paid'				=> $paid,
                                                                'sale_status'		=> $sale_status,
                                                                'payment_status'	=> 'due'
                                                                );
                                                                $transq_20 =array
                                                                (
                                                                    'type'             	=> 'income',
                                                                    'account'          	=> '5',
                                                                    'category'         	=> '8',
                                                                    'date'              => $data['date'],
                                                                        'pay_date'              => $data['pay_date'],
                                                                    'amount'            => $balance_2,
                                                                    'note'              => '',
                                                                    'description'       => 'Sale',
                                                                    'acc_type'          => '18',
                                                                    'deposit_withdrawal'=> 'deposit',
                                                                    'sale_id' 			=> $row->id,
                                                                    'warehouse_id'		=> $warehouse_id,
                                                                    'customer_id'           => $data['company_id'],
                                                                    'category_id'           => $data['category_id'],
                                                                    'voucher'              => $data['voucher']
                                                                );
                                                                $paymentq_20 = array
                                                                (
                                                                    'date' 			=> $data['date'],
                                                                    'reference_no' 	=> $payment['reference_no'],
                                                                    'amount' 		=> $balance_2,
                                                                    'paid_by' 		=> $data['paid_by'],
                                                                    'cheque_no' 	=> '',
                                                                    'cc_no' 		=> '',
                                                                    'cc_holder' 	=> '',
                                                                    'cc_month' 		=> '',
                                                                    'cc_year' 		=> '',
                                                                    'cc_type' 		=> '',
                                                                    'created_by' 	=> $data['created_by'],
                                                                    'note' 			=> '',
                                                                    'type' 			=> 'received',
                                                                    'sale_id' 		=> $row->id
                                                        
                                                                );  
                                                                if($this->db->update('sales', $daq_20, array('id' => $row->id)) &&  $this->db->insert('transaction', $transq_20) && $this->db->insert('payments', $paymentq_20) )
                                                                {
                                                                
                                                                    //print_r($trans);die();
                                                                    $this->site->updateReference('pay');
                                                                    //return true;
                                                                }
                                                            } 
                                                            elseif($data['amount'] > $balance_2)
                                                            {
                                                                $payment_status = 'paid';
                                                                $sale_status = 'completed';
                                                                $paid = $paid +  $balance_2;
                                                                $data['amount']= $data['amount'] -  $balance_2 ;
                                                                $payment['reference_no'] = $this->site->getReference('pay');
                                                                $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                                                $daf_21 =array
                                                                (
                                                                    'paid'=>$paid,
                                                                    'sale_status'=> $sale_status,
                                                                    'payment_status'=> 'paid'
                                                                );
                                                                $transf_21 =array
                                                                (
                                                                    'type'             	=>'income',
                                                                    'account'          	=>'5',
                                                                    'category'         	=>'8',
                                                                    'date'              =>$data['date'],
                                                                        'pay_date'              => $data['pay_date'],
                                                                    'amount'            =>$balance_2,
                                                                    'note'              => '',
                                                                    'description'       => 'Sale',
                                                                    'acc_type'          =>  '18',
                                                                    'deposit_withdrawal'=> 'deposit',
                                                                    'sale_id' 			=> $row->id,
                                                                    'warehouse_id'		=>$warehouse_id,
                                                                    'customer_id'           => $data['company_id'],
                                                                    'category_id'           => $data['category_id'],
                                                                    'voucher'              => $data['voucher']
                                                                );
                                                                $paymentf_21 = array
                                                                (
                                                                    'date' 			=> $data['date'],
                                                                    'reference_no' 	=> $payment['reference_no'],
                                                                    'amount' 		=> $balance_2,
                                                                    'paid_by' 		=> $data['paid_by'],
                                                                    'cheque_no' 	=> '',
                                                                    'cc_no' 		=> '',
                                                                    'cc_holder' 	=> '',
                                                                    'cc_month' 		=> '',
                                                                    'cc_year' 		=> '',
                                                                    'cc_type' 		=> '',
                                                                    'created_by' 	=> $data['created_by'],
                                                                    'note' 			=> '',
                                                                    'type' 			=> 'received',
                                                                    'sale_id' 		=> $row->id
                                                        
                                                                );
                                                                if($this->db->update('sales', $daf_21, array('id' => $row->id)) &&  $this->db->insert('transaction', $transf_21) && $this->db->insert('payments', $paymentf_21) )
                                                                {
                                                            // 	bal = 100;
                                                            // 	deposit = saved
                                                                
                                                                    //print_r($trans);die();
                                                                    $this->site->updateReference('pay');
                                                                    //return true;
                                                                }
                                                            } 
                                                
                                                        }
                                                        
                                                    }
                                                        
                                        }
                                    }
                                }
                                else
                                {
                                    $this->session->set_flashdata('message', lang("Deposit_amount_exceeded"));
                                }
                            }
                                                    
                                                    
                        }
                        elseif($previs_amnts > $data['amount'])
                        {
                            //echo"3";die();
                            $dep_amnts      = $previs_amnts;//$this->db->get_where('companies',array('id' => $data['company_id']))->row()->deposit_amount;
                            $warehouses     = $this->db->get_where('companies',array('id' => $data['company_id']))->row()->warehouse_id;
                            $paid_amount	= $previs_amnts -$data['amount'];
                            $transt_5 =array
                            (
                                 'type'             	=> 'income',
                                 'account'          	=> '5',
                                 'category'         	=> '8',
                                 'date'              	=> $data['date'],
                                 'pay_date'             => $data['pay_date'],
                                 'amount'            	=> $data['amount'],
                                 'note'              	=> '',
                                 'description'       	=> 'Sale',
                                 'acc_type'          	=> '18',
                                 'deposit_withdrawal' 	=> 'deposit',
                                 'sale_id' 				=> '',
                                 'warehouse_id'			=> $warehouses,
                                 'customer_id'          => $data['company_id'],
                                 'category_id'          => $data['category_id'],
                                 'voucher'              => $data['voucher'],
                                 'payment_status'        => "paid"
                              );
                             $paymentt_5 = array
                             (
                                 'date' 		=> $data['date'],
                                 'reference_no' => $payment['reference_no'],
                                 'amount' 		=> $data['amount'],
                                 'paid_by' 		=> $data['paid_by'],
                                 'cheque_no' 	=> '',
                                 'cc_no' 		=> '',
                                 'cc_holder' 	=> '',
                                 'cc_month' 	=> '',
                                 'cc_year' 		=> '',
                                 'cc_type' 		=> '',
                                 'created_by' 	=> $data['created_by'],
                                 'note' 		=> '',
                                 'type' 		=> 'received',
                                 'sale_id' 		=>''
                             );//print_r($payment);die(); 
                             $dat_5 = array
                             (
                                 'deposit_amount'			=>-$paid_amount,
                                 
                             );
                             //print_r($dat);die();
                             if($this->db->update('companies', $dat_5, array('id' =>$data['company_id'])) &&  $this->db->insert('transaction', $transt_5) &&$this->db->insert('payments', $paymentt_5) )
                             {
                           
                                 //print_r($trans);die();
                                 $this->site->updateReference('pay');
                                 //return true;
                             }
                        }
                    }  
                    else
                    {
                         //echo"2";die();
                        $this->db
                                ->select('*')
                                ->from('sales')
                                ->where('customer_id',$data['company_id'])
                                ->where('category_id',$cat_id)
                                ->where("(payment_status='pending' OR payment_status='due')", NULL, FALSE)
                                ->order_by("id", "asc"); 
                                $sale = $this->db->get();
                                //print_r($sale->result());die();
                        foreach($sale->result() as $row)
                        {
                            if($data['amount'] !=0)
                            {
                                $paid 			=$row->paid ? $row->paid:'0';
                                $grandtotal  	= $row->grand_total;//print_r($payment_status);
                                
                                if($grandtotal == $data['amount'])
                                {
                                    $balance 					= $grandtotal - $paid;
                                    $payment_status 			= 'paid';
                                    $sale_status 				= 'completed';
                                    $paid 						= $paid +  $balance;
                                    $data['amount']				= $data['amount'] - $balance;
                                    $payment['reference_no'] 	= $this->site->getReference('pay');
                                    $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                    $transt_6 =array
                                    (
                                        'type'             		=> 'income',
                                        'account'          		=> '5',
                                        'category'         		=> '8',
                                        'date'              	=> $data['date'],
                                        'pay_date'              => $data['pay_date'],
                                        'amount'            	=> $balance,
                                        'note'              	=> '',
                                        'description'       	=> 'Sale',
                                        'acc_type'          	=> '18',
                                        'deposit_withdrawal' 	=> 'deposit',
                                        'sale_id' 				=> $row->id,
                                        'warehouse_id'			=> $warehouse_id,
                                        'customer_id'           => $data['company_id'],
                                        'category_id'           => $data['category_id'],
                                        'voucher'              => $data['voucher'],
                                    );
                                    $paymentt_6 = array
                                    (
                                        'date' 			=> $data['date'],
                                        'reference_no' 	=> $payment['reference_no'],
                                        'amount' 		=>  $balance,
                                        'paid_by' 		=> $data['paid_by'],
                                        'cheque_no' 	=> '',
                                        'cc_no' 		=> '',
                                        'cc_holder' 	=> '',
                                        'cc_month' 		=> '',
                                        'cc_year' 		=> '',
                                        'cc_type' 		=> '',
                                        'created_by' 	=> $data['created_by'],
                                        'note' 			=> '',
                                        'type' 			=> 'received',
                                        'sale_id' 		=> $row->id
                                    );//print_r($payment);die();
                                    $dat_6 = array
                                    (
                                        'paid'			=>$paid,
                                        'sale_status'	=> $sale_status,
                                        'payment_status'=> $payment_status
                                    );
                                    if($this->db->update('sales', $dat_6, array('id' => $row->id)) &&  $this->db->insert('transaction', $transt_6) &&$this->db->insert('payments', $paymentt_6) )
                                    {
                                
                                        //print_r($trans);die();
                                        $this->site->updateReference('pay');
                                        //return true;
                                    }
                                } 
                                elseif($data['amount'] > $grandtotal)
                                {
                            
                        
                                    $payment_status 			= 'paid';
                                    $sale_status 				= 'completed';
                                    $balance_3 					= $grandtotal - $paid;	
                                    $paid 						= $paid +  $balance_3;
                                    $data['amount']				= $data['amount'] - $balance_3;
                                    $payment['reference_no'] 	= $this->site->getReference('pay');
                                    $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                    $dar_7 =array
                                    (
                                        'paid'				=> $paid,
                                        'sale_status'		=> $sale_status,
                                        'payment_status'	=> $payment_status
                                    );	
                                    $transr_7 =array
                                    (
                                        'type'             	=> 'income',
                                        'account'          	=> '5',
                                        'category'         	=> '8',
                                        'date'              => $data['date'],
                                        'pay_date'              => $data['pay_date'],
                                        'amount'            => $balance_3,
                                        'note'              => '',
                                        'description'       => 'Sale',
                                        'acc_type'          =>  '18',
                                        'deposit_withdrawal'=> 'deposit',
                                        'sale_id' 			=> $row->id,
                                        'warehouse_id'		=> $warehouse_id,
                                        'customer_id'           => $data['company_id'],
                                        'category_id'           => $data['category_id'], 
                                        'voucher'              => $data['voucher']
                                    );
                                    $paymentr_7 = array
                                    (
                                        'date' 			=> $data['date'],
                                        'reference_no' 	=> $payment['reference_no'],
                                        'amount' 		=> $balance_3,
                                        'paid_by' 		=> $data['paid_by'],
                                        'cheque_no' 	=> '',
                                        'cc_no' 		=> '',
                                        'cc_holder' 	=> '',
                                        'cc_month' 		=> '',
                                        'cc_year' 		=> '',
                                        'cc_type' 		=> '',
                                        'created_by' 	=> $data['created_by'],
                                        'note' 			=> '',
                                        'type' 			=> 'received',
                                        'sale_id' 		=> $row->id
                                
                                    );
                                
                                    if($this->db->update('sales', $dar_7, array('id' => $row->id)) &&  $this->db->insert('transaction', $transr_7) && $this->db->insert('payments', $paymentr_7) )
                                    {
                                
                                        //print_r($trans);die();
                                        $this->site->updateReference('pay');
                                        //return true;
                                    }
                                } 
                                elseif($data['amount'] < $grandtotal)
                                {
                      
                                    $balance_5 = $grandtotal - $paid;
                                    if($data['amount'] == $balance_5)
                                    {
                                        $payment_status 		= 'paid';
                                        $sale_status 			= 'completed';
                                        $paid 					= $paid + $data['amount'];
                                        $data['amount']			=  0;
                                        $payment['reference_no']= $this->site->getReference('pay');
                                        $warehouse_id 			= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                        $das_8 =array
                                        (
                                            'paid'				=> $paid,
                                            'sale_status'		=> $sale_status,
                                            'payment_status'	=> 'paid'
                                        );
                                        $transs_8 =array
                                        (
                                            'type'             	=> 'income',
                                            'account'          	=> '5',
                                            'category'         	=> '8',
                                            'date'              => $data['date'],
                                            'pay_date'              => $data['pay_date'],
                                            'amount'            => $balance_5 - $data['amount'],
                                            'note'              => '',
                                            'description'       => 'Sale',
                                            'acc_type'          => '18',
                                            'deposit_withdrawal'=> 'deposit',
                                            'sale_id' 			=> $row->id,
                                            'warehouse_id'		=> $warehouse_id,
                                            'customer_id'           => $data['company_id'],
                                            'category_id'           => $data['category_id'],
                                            'voucher'              => $data['voucher']
                                        );
                                        $payments_8 = array
                                        (
                                            'date' 			=> $data['date'],
                                            'reference_no' 	=> $payment['reference_no'],
                                            'amount' 		=> $balance_5,
                                            'paid_by' 		=> $data['paid_by'],
                                            'cheque_no' 	=> '',
                                            'cc_no' 		=> '',
                                            'cc_holder' 	=> '',
                                            'cc_month' 		=> '',
                                            'cc_year' 		=> '',
                                            'cc_type' 		=> '',
                                            'created_by' 	=> $data['created_by'],
                                            'note' 			=> '',
                                            'type' 			=> 'received',
                                            'sale_id' 		=> $row->id
                                        );
                                        if($this->db->update('sales', $das_8, array('id' => $row->id)) &&  $this->db->insert('transaction', $transs_8) && $this->db->insert('payments', $payments_8) )
                                            {
                                        
                                                //print_r($trans);die();
                                                $this->site->updateReference('pay');
                                                //return true;
                                            }
                                    } 
                                    elseif($data['amount'] < $balance_5)
                                    {
                                        $payment_status 			= 'paid';
                                        $sale_status 				= 'completed';
                                        $paid 						= $paid + $data['amount'];
                                        $balance_5                  = $data['amount'];
                                        $data['amount']				=  0;
                                        $payment['reference_no'] 	= $this->site->getReference('pay');
                                        $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                        $daq_9 =array
                                        (
                                        'paid'				=> $paid,
                                        'sale_status'		=> $sale_status,
                                        'payment_status'	=> 'due'
                                        );
                                        $transq_9 =array
                                        (
                                            'type'             	=> 'income',
                                            'account'          	=> '5',
                                            'category'         	=> '8',
                                            'date'              => $data['date'],
                                                'pay_date'              => $data['pay_date'],
                                            'amount'            => $balance_5,
                                            'note'              => '',
                                            'description'       => 'Sale',
                                            'acc_type'          => '18',
                                            'deposit_withdrawal'=> 'deposit',
                                            'sale_id' 			=> $row->id,
                                            'warehouse_id'		=> $warehouse_id,
                                            'customer_id'           => $data['company_id'],
                                            'category_id'           => $data['category_id'],
                                            'voucher'              => $data['voucher']
                                        );
                                        $paymentq_9 = array
                                        (
                                            'date' 			=> $data['date'],
                                            'reference_no' 	=> $payment['reference_no'],
                                            'amount' 		=> $balance_5,
                                            'paid_by' 		=> $data['paid_by'],
                                            'cheque_no' 	=> '',
                                            'cc_no' 		=> '',
                                            'cc_holder' 	=> '',
                                            'cc_month' 		=> '',
                                            'cc_year' 		=> '',
                                            'cc_type' 		=> '',
                                            'created_by' 	=> $data['created_by'],
                                            'note' 			=> '',
                                            'type' 			=> 'received',
                                            'sale_id' 		=> $row->id
                                
                                        );  
                                        if($this->db->update('sales', $daq_9, array('id' => $row->id)) &&  $this->db->insert('transaction', $transq_9) && $this->db->insert('payments', $paymentq_9) )
                                        {
                                        
                                            //print_r($trans);die();
                                            $this->site->updateReference('pay');
                                            //return true;
                                        }
                                    } 
                                    elseif($data['amount'] > $balance_5)
                                    {
                                        $payment_status = 'paid';
                                        $sale_status = 'completed';
                                        $paid = $paid +  $balance_5;
                                        $data['amount']= $data['amount'] -  $balance_5 ;
                                        $payment['reference_no'] = $this->site->getReference('pay');
                                        $warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                        $daf_10 =array
                                        (
                                            'paid'=>$paid,
                                            'sale_status'=> $sale_status,
                                            'payment_status'=> 'paid'
                                        );
                                        $transf_10 =array
                                        (
                                            'type'             	=>'income',
                                            'account'          	=>'5',
                                            'category'         	=>'8',
                                            'date'              =>$data['date'],
                                                'pay_date'              => $data['pay_date'],
                                            'amount'            =>$balance_5 - $data['amount'],
                                            'note'              => '',
                                            'description'       => 'Sale',
                                            'acc_type'          =>  '18',
                                            'deposit_withdrawal'=> 'deposit',
                                            'sale_id' 			=> $row->id,
                                            'warehouse_id'		=>$warehouse_id,
                                            'customer_id'           => $data['company_id'],
                                            'category_id'           => $data['category_id'],
                                            'voucher'              => $data['voucher']
                                        );
                                        $paymentf_10 = array
                                        (
                                            'date' 			=> $data['date'],
                                            'reference_no' 	=> $payment['reference_no'],
                                            'amount' 		=> $balance_5,
                                            'paid_by' 		=> $data['paid_by'],
                                            'cheque_no' 	=> '',
                                            'cc_no' 		=> '',
                                            'cc_holder' 	=> '',
                                            'cc_month' 		=> '',
                                            'cc_year' 		=> '',
                                            'cc_type' 		=> '',
                                            'created_by' 	=> $data['created_by'],
                                            'note' 			=> '',
                                            'type' 			=> 'received',
                                            'sale_id' 		=> $row->id
                                
                                        );
                                        if($this->db->update('sales', $daf_10, array('id' => $row->id)) &&  $this->db->insert('transaction', $transf_10) && $this->db->insert('payments', $paymentf_10) )
                                        {
                                        
                                            //print_r($trans);die();
                                            $this->site->updateReference('pay');
                                            //return true;
                                        }
                                    } 
                        // echo"8";die();
                                }
                                $cfi 	=  $data['amount'];
                            $cdat 	= array('deposit_amount'=>$cfi);
                            $this->db->update('companies', $cdat, array('id' => $data['company_id']));
                            }
                                
                        }//die();
                    }
                }
                else
                {
                    //echo"1";die();
                        $this->db
                                ->select('*')
                                ->from('sales')
                                ->where('customer_id',$data['company_id'])
                                ->where('category_id',$cat_id)
                                ->where("(payment_status='pending' OR payment_status='due')", NULL, FALSE)
                                ->order_by("id", "asc"); 
                                $sale = $this->db->get();
                                
                        foreach($sale->result() as $row)
                        {
                            //echo $data['amount'];die();
                            if($data['amount'] !=0)
                    {
                            $paid           = $row->paid ? $row->paid:'0';
                            $grandtotal     = $row->grand_total;
                            
                        if($grandtotal == $data['amount'])
                        {
                            $balance                    = $grandtotal - $paid;
                            $payment_status             = 'paid';
                            $sale_status                = 'completed';
                            $paid                       = $paid +  $balance;
                            $data['amount']             = $data['amount'] - $balance;
                            $payment['reference_no']    = $this->site->getReference('pay');
                            $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                            $transt_a =array
                            (
                                'type'                  => 'income',
                                'account'               => '5',
                                'category'              => '8',
                                'date'                  => $data['date'],
                                'amount'                => $balance,
                                'note'                  => '',
                                'description'           => 'Sale',
                                'acc_type'              => '18',
                                'deposit_withdrawal'    => 'deposit',
                                'sale_id'               => $row->id,
                                'warehouse_id'          => $warehouse_id,
                                 'customer_id'           => $data['company_id'],
                             );
                            //print_r($transt);
                            $paymentt_a = array
                            (
                                'date'          => $data['date'],
                                'reference_no'  => $payment['reference_no'],
                                'amount'        =>  $balance,
                                'paid_by'       => $data['paid_by'],
                                'cheque_no'     => '',
                                'cc_no'         => '',
                                'cc_holder'     => '',
                                'cc_month'      => '',
                                'cc_year'       => '',
                                'cc_type'       => '',
                                'created_by'    => $data['created_by'],
                                'note'          => '',
                                'type'          => 'received',
                                 'sale_id'      => $row->id
                            );//print_r($payment);die();
                            $dat_a = array
                            (
                                'paid'          =>$paid,
                                'sale_status'   => $sale_status,
                                'payment_status'=> $payment_status
                            );
                            if($this->db->update('sales', $dat_a, array('id' => $row->id)) &&  $this->db->insert('transaction', $transt_a) &&$this->db->insert('payments', $paymentt_a) )
                            {
                          
                                //print_r($trans);die();
                                $this->site->updateReference('pay');
                                //return true;
                            }
                        } 
                        elseif($data['amount'] > $grandtotal)
                        {
                            //echo"3";die();
                    
                
                            $payment_status             = 'paid';
                            $sale_status                = 'completed';
                            $balance                    = $grandtotal - $paid;  
                            $paid                       = $paid +  $balance;
                            $data['amount']             = $data['amount'] - $balance;
                            $payment['reference_no']    = $this->site->getReference('pay');
                            $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                            $dar_b =array
                            (
                                 'paid'             => $paid,
                                 'sale_status'      => $sale_status,
                                 'payment_status'   => $payment_status
                            );  
                            $transr_b =array
                            (
                                'type'              => 'income',
                                'account'           => '5',
                                'category'          => '8',
                                'date'              => $data['date'],
                                'amount'            => $balance,
                                'note'              => '',
                                'description'       => 'Sale',
                                'acc_type'          =>  '18',
                                'deposit_withdrawal'=> 'deposit',
                                'sale_id'           => $row->id,
                                'warehouse_id'      => $warehouse_id,
                                 'customer_id'           => $data['company_id'],
                            );
                           // print_r($transr);
                            $paymentr_b = array
                            (
                                'date'          => $data['date'],
                                'reference_no'  => $payment['reference_no'],
                                'amount'        => $balance,
                                'paid_by'       => $data['paid_by'],
                                'cheque_no'     => '',
                                'cc_no'         => '',
                                'cc_holder'     => '',
                                'cc_month'      => '',
                                'cc_year'       => '',
                                'cc_type'       => '',
                                'created_by'    => $data['created_by'],
                                'note'          => '',
                                'type'          => 'received',
                                 'sale_id'      => $row->id
                       
                            );
                          
                            if($this->db->update('sales', $dar_b, array('id' => $row->id)) &&  $this->db->insert('transaction', $transr_b) && $this->db->insert('payments', $paymentr_b) )
                            {
                          
                                //print_r($trans);die();
                                $this->site->updateReference('pay');
                                //return true;
                            }
                        } 
                        elseif($data['amount'] < $grandtotal)
                        {
                            $balance = $grandtotal - $paid;
                           
                            if($data['amount'] == $balance)
                            {
                                $payment_status         = 'paid';
                                $sale_status            = 'completed';
                                $paid                   = $paid + $data['amount'];
                                $data['amount']         =  0;
                                $payment['reference_no']= $this->site->getReference('pay');
                                $warehouse_id           = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $das_c =array
                                (
                                     'paid'             => $paid,
                                     'sale_status'      => $sale_status,
                                     'payment_status'   => 'paid'
                                );
                                $transs_c =array
                                (
                                    'type'              => 'income',
                                    'account'           => '5',
                                    'category'          => '8',
                                    'date'              => $data['date'],
                                    'amount'            => $paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          => '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      => $warehouse_id,
                                     'customer_id'           => $data['company_id'],
                                );
                                $payments_c = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'received',
                                    'sale_id'       => $row->id
                                );
                                if($this->db->update('sales', $das_c, array('id' => $row->id)) &&  $this->db->insert('transaction', $transs_c) && $this->db->insert('payments', $payments_c) )
                                    {
                                  
                                        //print_r($trans);die();
                                        $this->site->updateReference('pay');
                                        //return true;
                                    }
                            } 
                            elseif($data['amount'] < $balance)
                            {
                                $payment_status             = 'paid';
                                $sale_status                = 'completed';
                                $paid                       = $paid + $data['amount'];
                                $data['amount']             =  0;
                                $payment['reference_no']    = $this->site->getReference('pay');
                                $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $daq_d =array
                                (
                                 'paid'             => $paid,
                                 'sale_status'      => $sale_status,
                                 'payment_status'   => 'due'
                                );
                                $transq_d =array
                                (
                                    'type'              => 'income',
                                    'account'           => '5',
                                    'category'          => '8',
                                    'date'              => $data['date'],
                                    'amount'            => $paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          => '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      => $warehouse_id,
                                     'customer_id'           => $data['company_id'],
                                );
                                //print_r($transr);
                                $paymentq_d = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'received',
                                    'sale_id'       => $row->id
                       
                                );  
                                if($this->db->update('sales', $daq_d, array('id' => $row->id)) &&  $this->db->insert('transaction', $transq_d) && $this->db->insert('payments', $paymentq_d) )
                                {
                                  
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                            } 
                            elseif($data['amount'] > $balance)
                            {
                                $payment_status = 'paid';
                                $sale_status = 'completed';
                                $paid = $paid +  $balance;
                                $data['amount']= $data['amount'] -  $balance ;
                                $payment['reference_no'] = $this->site->getReference('pay');
                                $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $daf_e =array
                                (
                                    'paid'=>$paid,
                                    'sale_status'=> $sale_status,
                                    'payment_status'=> 'paid'
                                );
                                $transf_e =array
                                (
                                    'type'              =>'income',
                                    'account'           =>'5',
                                    'category'          =>'8',
                                    'date'              =>$data['date'],
                                    'amount'            =>$paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          =>  '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      =>$warehouse_id,
                                     'customer_id'           => $data['company_id'],
                                );
                               // print_r($transr);
                                $paymentf_e = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'received',
                                    'sale_id'       => $row->id
                       
                                );

                                if($this->db->update('sales', $daf_e, array('id' => $row->id)) &&  $this->db->insert('transaction', $transf_e) && $this->db->insert('payments', $paymentf_e) )
                                {
                                  
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                            } 
                 
                        }
                         $cfi   =  $data['amount'];
                    $cdat   = array('deposit_amount'=>$cfi);
                    $this->db->update('companies', $cdat, array('id' => $data['company_id']));
                    }
                            //echo"48";die();    
                        }//die();
                    }
                return true; 
             
        }
    } 
    else
    {
       // print_r( $data);die();
        if($this->db->insert('deposits', $data))
        {
             $transt_17 =array
                         (
                             'type'             		=> 'previous balance',
                             'account'          		=> '5',
                             'category'         		=> '9',
                             'date'              	=> $data['date'],
                             'pay_date'              => $data['pay_date'],
                             'amount'            	=> -$data['amount'],
                             'note'              	=> '',
                             'description'       	=> '',
                             'acc_type'          	=> '27',
                             'deposit_withdrawal' 	=> 'withdrawal',
                             'sale_id' 				=> '',
                             'warehouse_id'			=> '',
                             'customer_id'           => $data['company_id'],
                             'category_id'           => $data['category_id'],
                             'voucher'              => $data['voucher'],
                          );
                    $this->db->insert('transaction', $transt_17); 
                    $amnt_17 = $this->db->get_where('companies',array('id' => $data['company_id']))->row()->deposit_amount;   
                    $cfii_17 	=  $amnt_17 + $data['amount'];
                    $cdat_17 	= array('deposit_amount'=>$cfii_17);
                    $this->db->update('companies', $cdat_17, array('id' => $data['company_id']));
        }
        return true;
    }
 
     
    return false;
 
 
 }
    
    
    
    public function addSupplier($data,$cdata)
    {//print_r($cdata);die();
       if ($this->db->insert('deposits', $data) && 
            $this->db->update('companies', $cdata, array('id' => $data['company_id']))) 
			{
               $this->db->order_by("id", "asc"); 
               $this->db
                        ->select('*')
                        ->from('purchases')
                        ->where('supplier_id',$data['company_id'])
                        ->where("(payment_status='pending' OR payment_status='due')", NULL, FALSE);
                        $sale = $this->db->get();
                        //print_r($sale->result());die();
                foreach($sale->result() as $row)
				{
					if($data['amount'] !=0)
					{
						$paid 			=$row->paid;
						$grandtotal 	= $row->grand_total;//print_r($payment_status);
						if($grandtotal == $data['amount'])
						{//echo"2";die();
						    $balance 					= $grandtotal - $paid;
							$payment_status 			= 'paid';
							$sale_status 				= 'completed';
							$paid 						= $paid +  $balance;
							$data['amount']				= $data['amount'] - $balance;
							$payment['reference_no'] 	= $this->site->getReference('pay');
							$warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
							$transfa =array
							(
								'type'             		=> 'expense',
								'account'          		=> '5',
								'category'         		=> '8',
								'date'              	=> $data['date'],
								'pay_date'              => $data['pay_date'],
								'amount'            	=> $balance,
								'note'              	=> $data['note'],
								'description'       	=> 'Sale',
								'acc_type'          	=> '18',
								'deposit_withdrawal' 	=> 'withdrawal',
								'sale_id' 				=> $row->id,
								'warehouse_id'			=> $warehouse_id,
									'voucher'              => $data['voucher'],
                             );
                            $paymentfa = array
							(
								'date' 			=> $data['date'],
								'reference_no' 	=> $payment['reference_no'],
								'amount' 		=>  $balance,
								'paid_by' 		=> $data['paid_by'],
								'cheque_no' 	=> '',
								'cc_no' 		=> '',
								'cc_holder' 	=> '',
								'cc_month' 		=> '',
								'cc_year' 		=> '',
								'cc_type' 		=> '',
								'created_by' 	=> $data['created_by'],
								'note' 			=> '',
								'type' 			=> 'received',
								 'sale_id' 		=> $row->id
							);//print_r($payment);die();
							$dafa = array
							(
								'paid'			=>$paid,
								'status'	=> $sale_status,
								'payment_status'=> $payment_status
                            );
                            if($this->db->update('purchases', $dafa, array('id' => $row->id)) &&  $this->db->insert('transaction', $transfa) &&$this->db->insert('payments', $paymentfa) )
							{
                          
								//print_r($trans);die();
								$this->site->updateReference('pay');
								//return true;
                            }
                        } 
                        if($data['amount'] > $grandtotal)
						{//echo"3";die();
							$payment_status 			= 'paid';
							$sale_status 				= 'completed';
							$balance 					= $grandtotal - $paid;
							$paid 						= $paid +  $balance;
							$data['amount']				= $data['amount'] - $balance;
							$payment['reference_no'] 	= $this->site->getReference('pay');
							$warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
							$daw =array
							(
								 'paid'				=> $paid,
								 'status'		=> $sale_status,
								 'payment_status'	=> $payment_status
                            );
							$transw =array
							(
								'type'             	=> 'expense',
								'account'          	=> '5',
								'category'         	=> '8',
								'date'              => $data['date'],
								'pay_date'              => $data['pay_date'],
								'amount'            => $balance,
								'note'              => $data['note'],
								'description'       => 'Sale',
								'acc_type'          =>  '18',
								'deposit_withdrawal'=> 'withdrawal',
								'sale_id' 			=> $row->id,
								'warehouse_id'		=> $warehouse_id,
									'voucher'              => $data['voucher'],
                            );
							$paymentw = array
							(
								'date' 			=> $data['date'],
								'reference_no' 	=> $payment['reference_no'],
								'amount' 		=> $balance,
								'paid_by' 		=> $data['paid_by'],
								'cheque_no' 	=> '',
								'cc_no' 		=> '',
								'cc_holder' 	=> '',
								'cc_month' 		=> '',
								'cc_year' 		=> '',
								'cc_type' 		=> '',
								'created_by' 	=> $data['created_by'],
								'note' 			=> '',
								'type' 			=> 'received',
								 'sale_id' 		=> $row->id
                       
							);
                          
							if($this->db->update('purchases', $daw, array('id' => $row->id)) &&  $this->db->insert('transaction', $transw) && $this->db->insert('payments', $paymentw) )
							{
                          
								//print_r($trans);die();
								$this->site->updateReference('pay');
								//return true;
                            }
                        } 
                        if($data['amount'] < $grandtotal)
						{//echo"4";die();
							$balance = $grandtotal - $paid;
							if($data['amount'] == $balance)
							{
								$payment_status 		= 'paid';
								$sale_status 			= 'completed';
								$paid 					= $paid + $data['amount'];
								$data['amount']			=  0;
								$payment['reference_no']= $this->site->getReference('pay');
								$warehouse_id 			= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
								$dae =array
								(
									 'paid'				=> $paid,
									 'status'		=> $sale_status,
									 'payment_status'	=> 'paid'
								);
								$transe =array
								(
									'type'             	=> 'expense',
									'account'          	=> '5',
									'category'         	=> '8',
									'date'              => $data['date'],
									'pay_date'              => $data['pay_date'],
									'amount'            => $balance,
									'note'              => $data['note'],
									'description'       => 'Sale',
									'acc_type'          => '18',
									'deposit_withdrawal'=> 'withdrawal',
									'sale_id' 			=> $row->id,
									'warehouse_id'		=> $warehouse_id,
										'voucher'              => $data['voucher'],
								);
								$paymente = array
								(
									'date' 			=> $data['date'],
									'reference_no' 	=> $payment['reference_no'],
									'amount' 		=> $balance,
									'paid_by' 		=> $data['paid_by'],
									'cheque_no' 	=> '',
									'cc_no' 		=> '',
									'cc_holder' 	=> '',
									'cc_month' 		=> '',
									'cc_year' 		=> '',
									'cc_type' 		=> '',
									'created_by' 	=> $data['created_by'],
									'note' 			=> '',
									'type' 			=> 'received',
									'sale_id' 		=> $row->id
								);
								if($this->db->update('purchases', $dae, array('id' => $row->id)) &&  $this->db->insert('transaction', $transe) && $this->db->insert('payments', $paymente) )
									{
								  
										//print_r($trans);die();
										$this->site->updateReference('pay');
										//return true;
									}
							} 
							if($data['amount'] < $balance)
							{
								$payment_status 			= 'paid';
								$sale_status 				= 'received';
								$paid 						= $paid + $data['amount'];
								$data['amount']				=  0;
								$payment['reference_no'] 	= $this->site->getReference('pay');
								$warehouse_id 				= $this->db->get_where('purchases',array('id'=>$row->id))->row()->warehouse_id;
								$dag =array
								(
								 'paid'				=> $paid,
								 'status'		=> $sale_status,
								 'payment_status'	=> 'due'
								);
								$transg =array
								(
									'type'             	=> 'expense',
									'account'          	=> '5',
									'category'         	=> '8',
									'date'              => $data['date'],
									'pay_date'              => $data['pay_date'],
									'amount'            => $balance,
									'note'              => $data['note'],
									'description'       => 'Sale',
									'acc_type'          => '18',
									'deposit_withdrawal'=> 'withdrawal',
									'sale_id' 			=> $row->id,
									'warehouse_id'		=> $warehouse_id,
										'voucher'              => $data['voucher'],
                                );
								$paymentg = array
								(
									'date' 			=> $data['date'],
									'reference_no' 	=> $payment['reference_no'],
									'amount' 		=> $balance,
									'paid_by' 		=> $data['paid_by'],
									'cheque_no' 	=> '',
									'cc_no' 		=> '',
									'cc_holder' 	=> '',
									'cc_month' 		=> '',
									'cc_year' 		=> '',
									'cc_type' 		=> '',
									'created_by' 	=> $data['created_by'],
									'note' 			=> '',
									'type' 			=> 'received',
									'sale_id' 		=> $row->id
                       
								);  //echo"kk";die();
								if($this->db->update('purchases', $dag, array('id' => $row->id)) &&  $this->db->insert('transaction', $transg) && $this->db->insert('payments', $paymentg) )
								{
								  
									//print_r($trans);die();
									$this->site->updateReference('pay');
									//return true;
								}
							} 
							if($data['amount'] > $balance)
							{
								$payment_status = 'paid';
								$sale_status = 'completed';
								$paid = $paid +  $balance;
								$data['amount']= $data['amount'] -  $balance ;
								$payment['reference_no'] = $this->site->getReference('pay');
								$warehouse_id 				= $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
								$dav =array
								(
									'paid'=>$paid,
									'status'=> $sale_status,
									'payment_status'=> 'paid'
								);
								$transv =array
								(
									'type'             	=>'expense',
									'account'          	=>'5',
									'category'         	=>'8',
									'date'              =>$data['date'],
									'pay_date'              => $data['pay_date'],
									'amount'            =>$balance,
									'note'              => $data['note'],
									'description'       => 'Sale',
									'acc_type'          =>  '18',
									'deposit_withdrawal'=> 'withdrawal',
									'sale_id' 			=> $row->id,
									'warehouse_id'		=>$warehouse_id,
										'voucher'              => $data['voucher'],
								);
								$paymentv = array
								(
									'date' 			=> $data['date'],
									'reference_no' 	=> $payment['reference_no'],
									'amount' 		=> $balance,
									'paid_by' 		=> $data['paid_by'],
									'cheque_no' 	=> '',
									'cc_no' 		=> '',
									'cc_holder' 	=> '',
									'cc_month' 		=> '',
									'cc_year' 		=> '',
									'cc_type' 		=> '',
									'created_by' 	=> $data['created_by'],
									'note' 			=> '',
									'type' 			=> 'received',
									'sale_id' 		=> $row->id
                       
								);
								if($this->db->update('purchases', $dav, array('id' => $row->id)) &&  $this->db->insert('transaction', $transv) && $this->db->insert('payments', $paymentv) )
								{
								  
									//print_r($trans);die();
									$this->site->updateReference('pay');
									//return true;
								}
							} 
                   
                        }
                         $cfi 	=  $data['amount'];
    			    $cdat 	= array('cf1'=>$cfi);
    			    $this->db->update('companies', $cdat, array('id' => $data['company_id']));
                    }
                       
                }//die();
            
            return true;
        }
        return false;
    }
    
    public function getAllTransactionbycat($category){

    
       $this->db
                ->select('*')
                 ->from('transaction');
         if ($category) {
                $this->db->where('category_id', $category);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
        
        
    }
    
    public function getAllTransactionbycus($customer){

    
       $this->db
                ->select('*')
                 ->from('transaction');
         if ($customer) {
                $this->db->where('customer_id', $customer);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
        
        
    }
    
    public function getAllTransactionbycus_cat($category,$customer)
    {
             $this->db
                ->select('sma_categories.name,transaction.type,transaction.voucher,transaction.amount,transaction.type,transaction.date as trans_date,transaction.pay_date,transaction.customer_id,transaction.category_id,transaction.account,transaction.category,transaction.deposit_withdrawal,transaction.payment_id,transaction.purchase_id,transaction.sale_id')
                 ->from('transaction')
                //  ->join('sales', 'sales.customer_id = transaction.customer_id', 'left')
                //  ->join('payments', 'payments.sale_id=sales.id', 'left')
                 ->join('categories', 'categories.id=transaction.category_id', 'left')
                 ->where('transaction.category_id', $category)
                 ->where('transaction.customer_id', $customer);

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAlldeposit_bycus_cat($category,$customer)
    {
             $this->db
                ->select('sma_categories.name,deposits.voucher,deposits.type,deposits.amount,deposits.date as deposit_date,deposits.pay_date as payed_date,deposits.company_id,deposits.category_id')
                 ->from('deposits')
                //  ->join('sales', 'sales.customer_id = transaction.customer_id', 'left')
                //  ->join('payments', 'payments.sale_id=sales.id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                 ->where('deposits.category_id', $category)
                 ->where('deposits.company_id', $customer);
               

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTrans_salebycus_cat($category,$customer)
    {
             $this->db
                ->select('*')
                 ->from('sales')
                 
                 ->where('category_id', $category)
                 ->where('customer_id', $customer);

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    // function check_amount($cus_id,$amnt){
    //     $this->db->select('*');
    //     $this->db->from('transaction');
    //     $this->db->where('customer_id',$cus_id);
    //     $this->db->where('amount <', $amnt); 
    //     $query = $this->db->get();
    //     return $query->result();
    //     if($query->num_rows() >= 0){
    //       return true;
    //     }
    //     else{
    //         return false;
    //     }
    
    // }
    
    public function check_totsaleamount($cus_id,$cat_id)
    {
             $this->db
                ->select('SUM(grand_total) as s_grand_total')
                 ->from('sales')
                 
                 ->where('category_id', $cat_id)
                 ->where('customer_id', $cus_id);

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
           foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function check_totprev_balance($cus_id,$cat_id)
    {
        $this->db->select('amount');
        $this->db->from('transaction');
        $this->db->where('type','previous balance');
        $this->db->where('customer_id',$cus_id);
        $this->db->where('category_id', $cat_id);

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
           foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    function check_amount($cus_id,$amnt,$amn_sale){
        $value= $amn_sale + $amnt + 5000;
         //print_r($value); die();
        $this->db->select('*');
        $this->db->from('transaction');
        $this->db->where('customer_id',$cus_id);
        $this->db->where('amount <', $value); 
        $query = $this->db->get();
        return $query->result();
        if($query->num_rows() >= 0){
           return true;
        }
        else{
            return false;
        }
    
    }
//   public function getAll_prev_Transaction()
//     {
// 		$q = $this->db->get_where('transaction', array('type' => 'previous balance'));
// 		if ($q->num_rows() > 0) 
// 		{
//           foreach (($q->result()) as $row)   {
//               $data[] = $row;
//             }
//             return $data;
//         }
//         return FALSE;
//     }
    
    
    public function getAll_prev_Transaction()
    {
             $this->db
                ->select('sma_companies.name as cust_name,sma_companies.company as cust_company,transaction.type,transaction.voucher,transaction.amount,transaction.type,transaction.date as trans_date,transaction.pay_date,transaction.customer_id,transaction.category_id,transaction.account,transaction.category,transaction.deposit_withdrawal,transaction.payment_id,transaction.purchase_id,transaction.sale_id')
                 ->from('transaction')
                ->join('companies', 'companies.id=transaction.customer_id', 'left')
                 ->where('transaction.type', 'previous balance');
                
        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
     public function get_prev_Transaction($category,$customer)
    {
            $this->db
                ->select('sma_companies.name as cust_name,sma_companies.company as cust_company,transaction.type,transaction.voucher,transaction.amount,transaction.type,transaction.date as trans_date,transaction.pay_date,transaction.customer_id,transaction.category_id,transaction.account,transaction.category,transaction.deposit_withdrawal,transaction.payment_id,transaction.purchase_id,transaction.sale_id')
                 ->from('transaction')
                ->join('companies', 'companies.id=transaction.customer_id', 'left')
                 ->where('transaction.type', 'previous balance')
                 ->where('transaction.category_id', $category)
                 ->where('transaction.customer_id', $customer);

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAll_customer_prev(){
        
         $s = "(SELECT customer_id,COALESCE(sum(sma_sales.total_bal_amount), 0) as total_amount,grand_total as grand_amount,date as sale_date from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 2') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) FS";
         $t = "(SELECT customer_id,COALESCE(sum(sma_sales.total_bal_amount), 0) as total_amount1,grand_total as grand_amount1,date as sale_date1 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 3') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) gS";
         $u = "(SELECT customer_id,COALESCE(sum(sma_sales.total_bal_amount), 0) as total_amount2,grand_total as grand_amount2,date as sale_date2 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 5') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) hS";
         $v = "(SELECT customer_id,COALESCE(sum(sma_sales.total_bal_amount), 0) as total_amount3
FROM {$this->db->dbprefix('sales')}
WHERE {$this->db->dbprefix('sales.category_id = 2') } 
OR {$this->db->dbprefix('sales.category_id = 3') }  OR {$this->db->dbprefix('sales.category_id = 5') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) mS";  

        $j = "(SELECT customer_id,category_id as trans_cat,amount as trans_amount,type as trans_type,date as trans_date,payment_status as trans_status from {$this->db->dbprefix('transaction')} WHERE {$this->db->dbprefix('transaction.category_id = 2') } GROUP BY {$this->db->dbprefix('transaction')}.customer_id ) jS";
        $k = "(SELECT customer_id,category_id as trans_cat1,amount as trans_amount1,type as trans_type1,date as trans_date1,payment_status as trans_status1 from {$this->db->dbprefix('transaction')} WHERE {$this->db->dbprefix('transaction.category_id = 3') } GROUP BY {$this->db->dbprefix('transaction')}.customer_id ) kS";
        $l = "(SELECT customer_id,category_id as trans_cat2,amount as trans_amount2,type as trans_type2,date as trans_date2,payment_status as trans_status2 from {$this->db->dbprefix('transaction')} WHERE {$this->db->dbprefix('transaction.category_id = 5') } GROUP BY {$this->db->dbprefix('transaction')}.customer_id ) lS";
        

        $this->db
            ->select("{$this->db->dbprefix('companies')}.id as customer_id, {$this->db->dbprefix('companies')}.company,{$this->db->dbprefix('companies')}.cf1, {$this->db->dbprefix('companies')}.name, {$this->db->dbprefix('companies')}.address, {$this->db->dbprefix('companies')}.phone, {$this->db->dbprefix('companies')}.price_group_name, {$this->db->dbprefix('companies')}.customer_group_name, {$this->db->dbprefix('companies')}.vat_no,{$this->db->dbprefix('warehouses')}.name as warehouse, {$this->db->dbprefix('companies')}.deposit_amount, {$this->db->dbprefix('companies')}.award_points,FS.total_amount,FS.grand_amount,FS.sale_date,gS.total_amount1,gS.grand_amount1,gS.sale_date1,hS.total_amount2,hS.grand_amount2,hS.sale_date2,mS.total_amount3,jS.trans_cat,jS.trans_amount,jS.trans_type,jS.trans_date,jS.trans_status,kS.trans_cat1,kS.trans_amount1,kS.trans_type1,kS.trans_date1,kS.trans_status1,lS.trans_cat2,lS.trans_amount2,lS.trans_type2,lS.trans_date2,lS.trans_status2")
            ->from("companies")
             ->join('warehouses', 'warehouses.id=companies.warehouse_id', 'left')
            ->join($s, 'FS.customer_id=companies.id','left')
            ->join($t, 'gS.customer_id=companies.id','left')
            ->join($u, 'hS.customer_id=companies.id','left')
            ->join($v, 'mS.customer_id=companies.id','left')
            ->join($j, 'jS.customer_id=companies.id','left')
            ->join($k, 'kS.customer_id=companies.id','left')
            ->join($l, 'lS.customer_id=companies.id','left')
            ->where('companies.group_name', 'customer')
            ->order_by('jS.customer_id', 'desc'); 
            // ->where('companies.deposit_amount !=',0.000);
            
            $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;

    }
    
    
    
    
    public function getAll_prev_Transaction_det($acc)
    {
             $this->db
              ->select('*')
              ->from('transaction')
              ->where('transaction.customer_id',$acc);
         $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
     public function get_customer_balance($customer)
    {
      // print_r($customer); die();
         $s = "(SELECT customer_id,COALESCE(sum(sma_sales.grand_total), 0) as total_amount from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 2') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) FS";
         $t = "(SELECT customer_id,COALESCE(sum(sma_sales.grand_total), 0) as total_amount1 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 3') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) gS";
         $u = "(SELECT customer_id,COALESCE(sum(sma_sales.grand_total), 0) as total_amount2 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 5') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) hS";
         $v = "(SELECT customer_id,COALESCE(sum(sma_sales.grand_total), 0) as total_amount3
FROM {$this->db->dbprefix('sales')}
WHERE {$this->db->dbprefix('sales.category_id = 2') } 
OR {$this->db->dbprefix('sales.category_id = 3') }  OR {$this->db->dbprefix('sales.category_id = 5') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) mS";  

        $j = "(SELECT customer_id,category_id as trans_cat,COALESCE(sum(sma_transaction.amount), 0) as trans_amount,type as trans_type from {$this->db->dbprefix('transaction')} WHERE {$this->db->dbprefix('transaction.category_id = 2') } GROUP BY {$this->db->dbprefix('transaction')}.customer_id ) jS";
        $k = "(SELECT customer_id,category_id as trans_cat1,COALESCE(sum(sma_transaction.amount), 0) as trans_amount1,type as trans_type1 from {$this->db->dbprefix('transaction')} WHERE {$this->db->dbprefix('transaction.category_id = 3') } GROUP BY {$this->db->dbprefix('transaction')}.customer_id ) kS";
        $l = "(SELECT customer_id,category_id as trans_cat2,COALESCE(sum(sma_transaction.amount), 0) as trans_amount2,type as trans_type2 from {$this->db->dbprefix('transaction')} WHERE {$this->db->dbprefix('transaction.category_id = 5') } GROUP BY {$this->db->dbprefix('transaction')}.customer_id ) lS";
        

        $this->db
            ->select("{$this->db->dbprefix('companies')}.id as customer_id, {$this->db->dbprefix('companies')}.company,{$this->db->dbprefix('companies')}.cf1, {$this->db->dbprefix('companies')}.name, {$this->db->dbprefix('companies')}.address, {$this->db->dbprefix('companies')}.phone, {$this->db->dbprefix('companies')}.price_group_name, {$this->db->dbprefix('companies')}.customer_group_name, {$this->db->dbprefix('companies')}.vat_no,{$this->db->dbprefix('warehouses')}.name as warehouse, {$this->db->dbprefix('companies')}.deposit_amount, {$this->db->dbprefix('companies')}.award_points,FS.total_amount,gS.total_amount1,hS.total_amount2,mS.total_amount3,jS.trans_cat,jS.trans_amount,jS.trans_type,kS.trans_cat1,kS.trans_amount1,lS.trans_cat2,lS.trans_amount2")
            ->from("companies")
            ->join('warehouses', 'warehouses.id=companies.warehouse_id', 'left')
            ->join($s, 'FS.customer_id=companies.id','left')
            ->join($t, 'gS.customer_id=companies.id','left')
            ->join($u, 'hS.customer_id=companies.id','left')
            ->join($v, 'mS.customer_id=companies.id','left')
            ->join($j, 'jS.customer_id=companies.id','left')
            ->join($k, 'kS.customer_id=companies.id','left')
            ->join($l, 'lS.customer_id=companies.id','left')
            ->where('companies.group_name', 'customer')
            ->where('companies.id', $customer);

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransaction_by_cct($trans_type,$category,$customer)
    {
      //  print_r($trans_type); die();
        $this->db
                ->select('*')
                 ->from('transaction');
         if ($trans_type && $category && $customer) {
                $this->db->where('type', $trans_type);
                $this->db->where('category_id', $category);
                $this->db->where('customer_id', $customer);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransaction_by_cctw($trans_type,$category,$customer,$warehouse)
    {
      //  print_r($trans_type); die();
        $this->db
                ->select('*')
                 ->from('transaction');
         if ($trans_type && $category && $customer && $warehouse) {
                $this->db->where('type', $trans_type);
                $this->db->where('category_id', $category);
                $this->db->where('customer_id', $customer);
                $this->db->where('warehouse_id', $warehouse);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransaction_by_type($trans_type)
    {
      //  print_r($trans_type); die();
        $this->db
                ->select('*')
                 ->from('transaction');
         if ($trans_type) {
                $this->db->where('type', $trans_type);
                }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransaction_by_details($trans_type,$category,$customer,$warehouse,$start_date,$to_date)
    {
        $this->db
                ->select('*')
                 ->from('transaction');
         if ($to_date) {
                $this->db->where('type', $trans_type);
                $this->db->where('category_id', $category);
                $this->db->where('customer_id', $customer);
                $this->db->where('warehouse_id', $warehouse);
                $this->db->where('DATE_FORMAT(date,"%Y-%m-%d")', $start_date);
                $this->db->where('DATE_FORMAT(pay_date,"%Y-%m-%d")', $to_date);
            }
            
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransaction_deposit()
    {
       
        $this->db
                ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,sma_companies.warehouse_id as company_warehouse,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                 ->order_by("deposits.id", "desc"); 
        $q = $this->db->get();        
        if ($q->num_rows() > 0)
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAlldeposit_by_details($category,$customer,$start_date,$to_date,$warehouse)
    {
      //    print_r($date); die();
        $this->db 
                 ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,sma_companies.warehouse_id as company_warehouse,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                  ->where('deposits.company_id', $customer)
                  ->where('deposits.category_id', $category)
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') >='$start_date'")
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') <='$to_date'")
                   ->where('companies.warehouse_id', $warehouse)
                  ->order_by("deposits.id", "desc"); 
                //  ->where('transaction.warehouse_id', $warehouse)
                //  ->where('DATE_FORMAT(date,"%Y-%m-%d")', $start_date);
                // ->where('transaction.type', 'income');
            $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
     public function getAlldeposit_by_cust($customer)
    {
      //    print_r($date); die();
        $this->db
                 ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,sma_companies.warehouse_id as company_warehouse,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                  ->where('deposits.company_id', $customer)
                  ->order_by("deposits.id", "desc"); 
            $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
     public function getAlldeposit_by_cat($category,$start_date,$to_date)
    {
      //    print_r($date); die();
        $this->db
                 ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                  ->where('deposits.category_id', $category)
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') >='$start_date'")
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') <='$to_date'")
                  ->order_by("deposits.id", "desc"); 
            $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
     public function getAlldeposit_customer($customer,$start_date,$to_date)
    {
      //    print_r($date); die();
        $this->db
                 ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                  ->where('deposits.company_id', $customer)
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') >='$start_date'")
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') <='$to_date'")
                  ->order_by("deposits.id", "desc"); 
            $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function getAlldeposit_by_warehouse($warehouse)
    {
      //    print_r($date); die();
        $this->db
                 ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,sma_companies.warehouse_id as company_warehouse,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                  ->where('companies.warehouse_id', $warehouse)
                  ->order_by("deposits.id", "desc"); 
            $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function get_warehouse_cat($warehouse,$category)
    {
      //    print_r($date); die();
        $this->db
                 ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,sma_companies.warehouse_id as company_warehouse,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                  ->where('companies.warehouse_id', $warehouse)
                  ->where('deposits.category_id', $category)
                  ->order_by("deposits.id", "desc"); 
            $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function get_warehouse_cat_date($warehouse,$category,$start_date,$to_date)
    {
      //    print_r($date); die();
        $this->db
                 ->select('sma_categories.name as cat_name,sma_companies.company as cust_company,sma_companies.name as cust_name,sma_companies.warehouse_id as company_warehouse,deposits.voucher,deposits.amount,deposits.date as trans_date,deposits.pay_date,deposits.company_id,deposits.category_id,deposits.note')
                 ->from('deposits')
                  ->join('companies', 'companies.id = deposits.company_id', 'left')
                 ->join('categories', 'categories.id=deposits.category_id', 'left')
                  ->where('companies.warehouse_id', $warehouse)
                  ->where('deposits.category_id', $category) 
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') >='$start_date'")
                  ->where("DATE_FORMAT(date,'%Y-%m-%d') <='$to_date'")
                  ->order_by("deposits.id", "desc"); 
            $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
}
