<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Customers extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if ($this->Customer || $this->Supplier) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        $this->lang->admin_load('customers', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('companies_model');
    }

    function index($warehouse_id = NULL,$action = NULL)
    {
        $this->sma->checkPermissions();
        
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        if ($this->Owner || $this->Admin || !$this->session->userdata('warehouse_id')) {
            $this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['warehouse_id'] = $warehouse_id;
            $this->data['warehouse'] = $warehouse_id ? $this->site->getWarehouseByID($warehouse_id) : NULL;
        } else {
            $this->data['warehouses'] = NULL;
            $this->data['warehouse_id'] = $this->session->userdata('warehouse_id');
            $this->data['warehouse'] = $this->session->userdata('warehouse_id') ? $this->site->getWarehouseByID($this->session->userdata('warehouse_id')) : NULL;
        }

         $this->data['action'] = $action;
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('customers')));
        $meta = array('page_title' => lang('customers'), 'bc' => $bc);
        $this->page_construct('customers/index', $meta, $this->data);
    }

    // function getCustomers($warehouse_id = NULL)
    // {
    //   $this->sma->checkPermissions('index', TRUE);
    //     $this->load->library('datatables');
    //      if ($warehouse_id) {
    //           $this->datatables
    //         ->select("{$this->db->dbprefix('companies')}.id as customer_id, {$this->db->dbprefix('companies')}.company, {$this->db->dbprefix('companies')}.name, {$this->db->dbprefix('companies')}.address, {$this->db->dbprefix('companies')}.phone, {$this->db->dbprefix('companies')}.price_group_name, {$this->db->dbprefix('companies')}.customer_group_name, {$this->db->dbprefix('companies')}.vat_no,{$this->db->dbprefix('warehouses')}.name as warehouse, {$this->db->dbprefix('companies')}.deposit_amount, {$this->db->dbprefix('companies')}.award_points")
    //         ->from("companies")
    //          ->join('warehouses', 'warehouses.id=companies.warehouse_id', 'left')
    //          ->where('companies.warehouse_id', $warehouse_id)
    //         ->where('companies.group_name', 'customer');
            
    //      }
    //              else{
             
    //     $this->datatables
    //         ->select("{$this->db->dbprefix('companies')}.id as customer_id, {$this->db->dbprefix('companies')}.company, {$this->db->dbprefix('companies')}.name, {$this->db->dbprefix('companies')}.address, {$this->db->dbprefix('companies')}.phone, {$this->db->dbprefix('companies')}.price_group_name, {$this->db->dbprefix('companies')}.customer_group_name, {$this->db->dbprefix('companies')}.vat_no,{$this->db->dbprefix('warehouses')}.name as warehouse, {$this->db->dbprefix('companies')}.deposit_amount, {$this->db->dbprefix('companies')}.award_points")
    //         ->from("companies")
    //          ->join('warehouses', 'warehouses.id=companies.warehouse_id', 'left')
    //         ->where('companies.group_name', 'customer');
    //              }
    //     $this->datatables->add_column("Actions", "<div class=\"text-center\"><a class=\"tip\" title='" . lang("list_deposits") . "' href='" . admin_url('customers/deposits/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-money\"></i></a> <a class=\"tip\" title='" . lang("add_deposit") . "' href='" . admin_url('customers/add_deposit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-plus\"></i></a> <a class=\"tip\" title='" . lang("list_addresses") . "' href='" . admin_url('customers/addresses/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-location-arrow\"></i></a> <a class=\"tip\" title='" . lang("list_users") . "' href='" . admin_url('customers/users/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-users\"></i></a> <a class=\"tip\" title='" . lang("add_user") . "' href='" . admin_url('customers/add_user/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-user-plus\"></i></a> <a class=\"tip\" title='" . lang("edit_customer") . "' href='" . admin_url('customers/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_customer") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('customers/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "customer_id");
    //     //->unset_column('id');
    //     echo $this->datatables->generate();
    // }
    
    function getCustomers($warehouse_id = NULL)
    {
       $this->sma->checkPermissions('index', TRUE);
        $this->load->library('datatables');
         if ($warehouse_id) {
             
        $w = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount, 0)) as deposit_amount from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 2') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) TS";
        $y = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount, 0)) as deposit_amount1 from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 3') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) US";
        $z = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount ,0)) as deposit_amount2 from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 5') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) VS";
        $c = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount ,0)) as deposit_amount4 from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 6') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) CS";
        
        $x = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount ,0)) as deposit_amount3
FROM {$this->db->dbprefix('deposits')}
WHERE {$this->db->dbprefix('deposits.category_id = 2') } 
OR {$this->db->dbprefix('deposits.category_id = 3') } OR {$this->db->dbprefix('deposits.category_id = 5') } OR {$this->db->dbprefix('deposits.category_id = 6') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) XS";  
   
             
         $s = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0))  as total_amount from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 2') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) FS";
         $t = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0)) as total_amount1 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 3') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) gS";
         $u = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0)) as total_amount2 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 5') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) hS";
         $b = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0)) as total_amount4 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 6') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) kS";
         
         $v = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total,0)) as total_amount3
FROM {$this->db->dbprefix('sales')}
WHERE {$this->db->dbprefix('sales.category_id = 2') } 
OR {$this->db->dbprefix('sales.category_id = 3') } OR {$this->db->dbprefix('sales.category_id= 5') } OR {$this->db->dbprefix('sales.category_id= 6') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) mS";  


   
            $this->load->library('datatables');  
              $this->datatables
            // ->select("{$this->db->dbprefix('companies')}.id as customer_id, {$this->db->dbprefix('companies')}.company,{$this->db->dbprefix('companies')}.cf1, {$this->db->dbprefix('companies')}.name, {$this->db->dbprefix('companies')}.address, {$this->db->dbprefix('companies')}.phone, {$this->db->dbprefix('companies')}.price_group_name, {$this->db->dbprefix('companies')}.customer_group_name, {$this->db->dbprefix('companies')}.vat_no,{$this->db->dbprefix('warehouses')}.name as warehouse, {$this->db->dbprefix('companies')}.deposit_amount, {$this->db->dbprefix('companies')}.award_points,( IFNULL(FS.total_amount,0) - TS.deposit_amount), (gS.total_amount1 - US.deposit_amount1), (hS.total_amount2 - VS.deposit_amount2), (mS.total_amount3 - XS.deposit_amount3)")
           ->select("{$this->db->dbprefix('companies')}.id as customer_id, {$this->db->dbprefix('companies')}.company,{$this->db->dbprefix('companies')}.cf1, {$this->db->dbprefix('companies')}.name, {$this->db->dbprefix('companies')}.address, {$this->db->dbprefix('companies')}.phone, {$this->db->dbprefix('companies')}.price_group_name, {$this->db->dbprefix('companies')}.vat_no,{$this->db->dbprefix('warehouses')}.name as warehouse, {$this->db->dbprefix('companies')}.deposit_amount, {$this->db->dbprefix('companies')}.award_points,( IFNULL(FS.total_amount,0) - (IFNULL(TS.deposit_amount,0))), (IFNULL(gS.total_amount1,0) - (IFNULL(US.deposit_amount1,0))), (IFNULL(hS.total_amount2,0) - (IFNULL(VS.deposit_amount2,0))), (IFNULL(kS.total_amount4,0) - (IFNULL(CS.deposit_amount4,0))), (IFNULL(mS.total_amount3,0) - (IFNULL(XS.deposit_amount3,0)))")
            ->from("companies")
            ->join('warehouses', 'warehouses.id=companies.warehouse_id', 'left')
            ->join($s, 'FS.customer_id=companies.id','left')
           ->join($t, 'gS.customer_id=companies.id','left')
            ->join($u, 'hS.customer_id=companies.id','left')
            ->join($b, 'kS.customer_id=companies.id','left')
            ->join($v, 'mS.customer_id=companies.id','left')
            ->join($w, 'TS.company_id=companies.id','left')
             ->join($y,'US.company_id=companies.id','left')
            ->join($z, 'VS.company_id=companies.id','left')
            ->join($c, 'CS.company_id=companies.id','left')
             ->join($x,'XS.company_id=companies.id','left')
             ->where('companies.warehouse_id', $warehouse_id)
            ->where('companies.group_name', 'customer');
            
         }
                 else{
        
        $w = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount, 0)) as deposit_amount from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 2') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) TS";
        $y = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount, 0)) as deposit_amount1 from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 3') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) US";
        $z = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount ,0)) as deposit_amount2 from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 5') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) VS";
        $c = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount ,0)) as deposit_amount4 from {$this->db->dbprefix('deposits')} WHERE {$this->db->dbprefix('deposits.category_id = 6') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) CS";
        
        $x = "(SELECT company_id,SUM(IFNULL(sma_deposits.amount ,0)) as deposit_amount3
FROM {$this->db->dbprefix('deposits')}
WHERE {$this->db->dbprefix('deposits.category_id = 2') } 
OR {$this->db->dbprefix('deposits.category_id = 3') } OR {$this->db->dbprefix('deposits.category_id = 5') } OR {$this->db->dbprefix('deposits.category_id = 6') } GROUP BY {$this->db->dbprefix('deposits')}.company_id ) XS";  
   
        $s = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0))  as total_amount from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 2') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) FS";
         $t = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0)) as total_amount1 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 3') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) gS";
         $u = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0)) as total_amount2 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 5') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) hS";
         $b = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total ,0)) as total_amount4 from {$this->db->dbprefix('sales')} WHERE {$this->db->dbprefix('sales.category_id = 6') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) kS";
         
         $v = "(SELECT customer_id,SUM(IFNULL(sma_sales.grand_total,0)) as total_amount3
FROM {$this->db->dbprefix('sales')}
WHERE {$this->db->dbprefix('sales.category_id = 2') } 
OR {$this->db->dbprefix('sales.category_id = 3') } OR {$this->db->dbprefix('sales.category_id= 5') }  OR {$this->db->dbprefix('sales.category_id= 6') } GROUP BY {$this->db->dbprefix('sales')}.customer_id ) mS";  

         
         $this->load->library('datatables');  
              $this->datatables
            ->select("{$this->db->dbprefix('companies')}.id as customer_id, {$this->db->dbprefix('companies')}.company,{$this->db->dbprefix('companies')}.cf1, {$this->db->dbprefix('companies')}.name, {$this->db->dbprefix('companies')}.address, {$this->db->dbprefix('companies')}.phone, {$this->db->dbprefix('companies')}.price_group_name, {$this->db->dbprefix('companies')}.vat_no,{$this->db->dbprefix('warehouses')}.name as warehouse, {$this->db->dbprefix('companies')}.deposit_amount, {$this->db->dbprefix('companies')}.award_points,( IFNULL(FS.total_amount,0) - (IFNULL(TS.deposit_amount,0))), (IFNULL(gS.total_amount1,0) - (IFNULL(US.deposit_amount1,0))), (IFNULL(hS.total_amount2,0) - (IFNULL(VS.deposit_amount2,0))),(IFNULL(kS.total_amount4,0) - (IFNULL(CS.deposit_amount4,0))), (IFNULL(mS.total_amount3,0) - (IFNULL(XS.deposit_amount3,0)))")
            ->from("companies")
            ->join('warehouses', 'warehouses.id=companies.warehouse_id', 'left')
            ->join($s, 'FS.customer_id=companies.id','left')
           ->join($t, 'gS.customer_id=companies.id','left')
            ->join($u, 'hS.customer_id=companies.id','left')
            ->join($b, 'kS.customer_id=companies.id','left')
            ->join($v, 'mS.customer_id=companies.id','left')
            ->join($w, 'TS.company_id=companies.id','left')
             ->join($y,'US.company_id=companies.id','left')
            ->join($z, 'VS.company_id=companies.id','left')
            ->join($c, 'CS.company_id=companies.id','left')
             ->join($x,'XS.company_id=companies.id','left')
            ->where('companies.group_name', 'customer');
                 }
        $this->datatables->add_column("Actions", "<div class=\"text-center\"><a class=\"tip\" title='" . lang("edit_customer") . "' href='" . admin_url('customers/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_customer") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('customers/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "customer_id");
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    // function getCustomers()
    // {
    //     $this->data['warehouses'] = $this->site->getAllWarehouses();
    //     $this->data['customer_list'] = $this->companies_model->getAllCustomerCompanies();
      
    //     $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('customers/getCustomers')));
    //     $meta = array('page_title' => lang('customers'), 'bc' => $bc);
    //     $this->page_construct('customers/index', $meta, $this->data);
        
    // }


    function view($id = NULL)
    {
        $this->sma->checkPermissions('index', true);
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['customer'] = $this->companies_model->getCompanyByID($id);
        $this->load->view($this->theme.'customers/view',$this->data);
    }

    function add()
    {
        $this->sma->checkPermissions(false, true);

        $this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');

        if ($this->form_validation->run('companies/add') == true) {
            $cg = $this->site->getCustomerGroupByID($this->input->post('customer_group'));
            $pg = $this->site->getPriceGroupByID($this->input->post('price_group'));
             $warehouse_id = $this->input->post('warehouse');
            $data = array('name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'group_id' => '3',
                'group_name' => 'customer',
                'customer_group_id' => $this->input->post('customer_group'),
                'customer_group_name' => $cg->name,
                'price_group_id' => $this->input->post('price_group') ? $this->input->post('price_group') : NULL,
                'price_group_name' => $this->input->post('price_group') ? $pg->name : NULL,
                'company' => $this->input->post('company'),
                'address' => $this->input->post('address'),
                'vat_no' => $this->input->post('vat_no'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'postal_code' => $this->input->post('postal_code'),
                'country' => $this->input->post('country'),
                'phone' => $this->input->post('phone'),
                'cf1' => $this->input->post('cf1'),
                'cf2' => $this->input->post('cf2'),
                'cf3' => $this->input->post('cf3'),
                'cf4' => $this->input->post('cf4'),
                'cf5' => $this->input->post('cf5'),
                'cf6' => $this->input->post('cf6'),
                'warehouse_id' => $warehouse_id,
            );
        } elseif ($this->input->post('add_customer')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('customers');
        }

        if ($this->form_validation->run() == true && $cid = $this->companies_model->addCompany($data)) {
            $this->session->set_flashdata('message', lang("customer_added"));
            $ref = isset($_SERVER["HTTP_REFERER"]) ? explode('?', $_SERVER["HTTP_REFERER"]) : NULL;
            admin_redirect($ref[0] . '?customer=' . $cid);
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['customer_groups'] = $this->companies_model->getAllCustomerGroups();
            $this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['price_groups'] = $this->companies_model->getAllPriceGroups();
            $this->load->view($this->theme . 'customers/add', $this->data);
        }
    }

    function edit($id = NULL)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $company_details = $this->companies_model->getCompanyByID($id);
        

        if ($this->form_validation->run('companies/add') == true) {
            $cg = $this->site->getCustomerGroupByID($this->input->post('customer_group'));
            $pg = $this->site->getPriceGroupByID($this->input->post('price_group'));
            $warehouse_id = $this->input->post('warehouse');
            $data = array('name' => $this->input->post('name'),
                'email' => '',
                'group_id' => '3',
                'group_name' => 'customer',
                'customer_group_id' => $this->input->post('customer_group'),
                'customer_group_name' => $cg->name,
                'price_group_id' => $this->input->post('price_group') ? $this->input->post('price_group') : NULL,
                'price_group_name' => $this->input->post('price_group') ? $pg->name : NULL,
                'company' => $this->input->post('company'),
                'address' => $this->input->post('address'),
                'vat_no' => $this->input->post('vat_no'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'postal_code' => $this->input->post('postal_code'),
                'country' => $this->input->post('country'),
                'phone' => $this->input->post('phone'),
                'cf1' => $this->input->post('cf1'),
                'cf2' => $this->input->post('cf2'),
                'cf3' => $this->input->post('cf3'),
                'cf4' => $this->input->post('cf4'),
                'cf5' => $this->input->post('cf5'),
                'cf6' => $this->input->post('cf6'),
                'warehouse_id' => $warehouse_id,
                'award_points' => $this->input->post('award_points'),
            );
        } elseif ($this->input->post('edit_customer')) {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->form_validation->run() == true && $this->companies_model->updateCompany($id, $data)) {
            $this->session->set_flashdata('message', lang("customer_updated"));
            redirect($_SERVER["HTTP_REFERER"]);
        } else {
            $this->data['customer'] = $company_details;
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['customer_groups'] = $this->companies_model->getAllCustomerGroups();
            $this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['price_groups'] = $this->companies_model->getAllPriceGroups();
            $this->load->view($this->theme . 'customers/edit', $this->data);
        }
    }

    function users($company_id = NULL)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $company_id = $this->input->get('id');
        }


        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['modal_js'] = $this->site->modal_js();
        $this->data['company'] = $this->companies_model->getCompanyByID($company_id);
        $this->data['users'] = $this->companies_model->getCompanyUsers($company_id);
        $this->load->view($this->theme . 'customers/users', $this->data);

    }

    function add_user($company_id = NULL)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $company_id = $this->input->get('id');
        }
        $company = $this->companies_model->getCompanyByID($company_id);

        $this->form_validation->set_rules('email', lang("email_address"), 'is_unique[users.email]');
        $this->form_validation->set_rules('password', lang('password'), 'required|min_length[8]|max_length[20]|matches[password_confirm]');
        $this->form_validation->set_rules('password_confirm', lang('confirm_password'), 'required');

        if ($this->form_validation->run('companies/add_user') == true) {
            $active = $this->input->post('status');
            $notify = $this->input->post('notify');
            list($username, $domain) = explode("@", $this->input->post('email'));
            $email = strtolower($this->input->post('email'));
            $password = $this->input->post('password');
            $additional_data = array(
                'first_name' => $this->input->post('first_name'),
                'last_name' => $this->input->post('last_name'),
                'phone' => $this->input->post('phone'),
                'gender' => $this->input->post('gender'),
                'company_id' => $company->id,
                'company' => $company->company,
                'group_id' => 3
            );
            $this->load->library('ion_auth');
        } elseif ($this->input->post('add_user')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('customers');
        }

        if ($this->form_validation->run() == true && $this->ion_auth->register($username, $password, $email, $additional_data, $active, $notify)) {
            $this->session->set_flashdata('message', lang("user_added"));
            admin_redirect("customers");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['company'] = $company;
            $this->load->view($this->theme . 'customers/add_user', $this->data);
        }
    }

    function import_csv()
    {
        $this->sma->checkPermissions('add', true);
        $this->load->helper('security');
        $this->form_validation->set_rules('csv_file', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {

            if (DEMO) {
                $this->session->set_flashdata('warning', lang("disabled_in_demo"));
                redirect($_SERVER["HTTP_REFERER"]);
            }

            if (isset($_FILES["csv_file"])) /* if($_FILES['userfile']['size'] > 0) */ {

                $this->load->library('upload');

                $config['upload_path'] = 'assets/uploads/csv/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;

                $this->upload->initialize($config);

                if (!$this->upload->do_upload('csv_file')) {

                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect("customers");
                }

                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen("assets/uploads/csv/" . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 5001, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                $titles = array_shift($arrResult);

                $keys = array('company', 'name', 'email', 'phone', 'address', 'city', 'state', 'postal_code', 'country', 'vat_no', 'cf1', 'cf2', 'cf3', 'cf4', 'cf5', 'cf6');

                $final = array();
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }
                $rw = 2;
                foreach ($final as $csv) {
                    if ($this->companies_model->getCompanyByEmail($csv['email'])) {
                        $this->session->set_flashdata('error', lang("check_customer_email") . " (" . $csv['email'] . "). " . lang("customer_already_exist") . " (" . lang("line_no") . " " . $rw . ")");
                        admin_redirect("customers");
                    }
                    $rw++;
                }
                foreach ($final as $record) {
                    $record['group_id'] = 3;
                    $record['group_name'] = 'customer';
                    $record['customer_group_id'] = 1;
                    $record['customer_group_name'] = 'General';
                    $data[] = $record;
                }
                //$this->sma->print_arrays($data);
            }

        } elseif ($this->input->post('import')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('customers');
        }

        if ($this->form_validation->run() == true && !empty($data)) {
            if ($this->companies_model->addCompanies($data)) {
                $this->session->set_flashdata('message', lang("customers_added"));
                admin_redirect('customers');
            }
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'customers/import', $this->data);
        }
    }

    function delete($id = NULL)
    {
        $this->sma->checkPermissions(NULL, TRUE);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->input->get('id') == 1) {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("customer_x_deleted")));
        }

        if ($this->companies_model->deleteCustomer($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("customer_deleted")));
        } else {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("customer_x_deleted_have_sales")));
        }
    }

    function suggestions($term = NULL, $limit = NULL)
    {
        // $this->sma->checkPermissions('index');
        if ($this->input->get('term')) {
            $term = $this->input->get('term', TRUE);
        }
        if (strlen($term) < 1) {
            return FALSE;
        }
        $limit = $this->input->get('limit', TRUE);
        $rows['results'] = $this->companies_model->getCustomerSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }

    function getCustomer($id = NULL)
    {
        // $this->sma->checkPermissions('index');
        $row = $this->companies_model->getCompanyByID($id);
        $this->sma->send_json(array(array('id' => $row->id, 'text' => ($row->company != '-' ? $row->company : $row->name))));
    }

    function get_customer_details($id = NULL)
    {
        $this->sma->send_json($this->companies_model->getCompanyByID($id));
    }

    function get_award_points($id = NULL)
    {
        $this->sma->checkPermissions('index');
        $row = $this->companies_model->getCompanyByID($id);
        $this->sma->send_json(array('ca_points' => $row->award_points));
    }

    function customer_actions($wh = NULL)
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->companies_model->deleteCustomer($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('customers_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', lang("customers_deleted"));
                    }
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                   $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('customer'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('company'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('name_arabic'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('phone'));
                    $this->excel->getActiveSheet()->SetCellValue('E1', lang('address'));
                    $this->excel->getActiveSheet()->SetCellValue('F1', lang('city'));
                    $this->excel->getActiveSheet()->SetCellValue('G1', lang('state'));
                    $this->excel->getActiveSheet()->SetCellValue('H1', lang('postal_code'));
                    $this->excel->getActiveSheet()->SetCellValue('I1', lang('country'));
                    $this->excel->getActiveSheet()->SetCellValue('J1', lang('vat_no'));
                    $this->excel->getActiveSheet()->SetCellValue('K1', lang('deposit_amount'));
                    $this->excel->getActiveSheet()->SetCellValue('L1', lang('Trolley_bag_balance'));
                    $this->excel->getActiveSheet()->SetCellValue('M1', lang('Footwear_Balance'));
                    $this->excel->getActiveSheet()->SetCellValue('N1', lang('Readymade_Balance'));
                    $this->excel->getActiveSheet()->SetCellValue('O1', lang('Fish_Balance'));
                    $this->excel->getActiveSheet()->SetCellValue('P1', lang('Total_Balance'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                         
                        $customer1 = $this->site->getCompanyByID($id);
                        $customer = $this->site->getCompanyBy_cat($id);
                        
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $customer->company);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $customer->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $customer->cf1);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $customer->phone);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $customer->address);
                        $this->excel->getActiveSheet()->SetCellValue('F' . $row, $customer->city);
                        $this->excel->getActiveSheet()->SetCellValue('G' . $row, $customer->state);
                        $this->excel->getActiveSheet()->SetCellValue('H' . $row, $customer->postal_code);
                        $this->excel->getActiveSheet()->SetCellValue('I' . $row, $customer->country);
                        $this->excel->getActiveSheet()->SetCellValue('J' . $row, $customer->vat_no);
                        $this->excel->getActiveSheet()->SetCellValue('K' . $row, $customer->deposit_amount);
                        $this->excel->getActiveSheet()->SetCellValue('L' . $row, $customer->total_amount);
                        $this->excel->getActiveSheet()->SetCellValue('M' . $row, $customer->total_amount1);
                        $this->excel->getActiveSheet()->SetCellValue('N' . $row, $customer->total_amount2);
                        $this->excel->getActiveSheet()->SetCellValue('O' . $row, $customer->total_amount4);
                        $this->excel->getActiveSheet()->SetCellValue('P' . $row, $customer->total_amount3);
                        $row++;
                       
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'customers_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_customer_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function deposits($company_id = NULL)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $company_id = $this->input->get('id');
        }

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['modal_js'] = $this->site->modal_js();
        $this->data['company'] = $this->companies_model->getCompanyByID($company_id);
        $this->load->view($this->theme . 'customers/deposits', $this->data);

    }

    function get_deposits($company_id = NULL)
    {
        $this->sma->checkPermissions('deposits');
        $this->load->library('datatables');
        $this->datatables
            ->select("deposits.id as id, date, amount, paid_by, CONCAT({$this->db->dbprefix('users')}.first_name, ' ', {$this->db->dbprefix('users')}.last_name) as created_by", false)
            ->from("deposits")
            ->join('users', 'users.id=deposits.created_by', 'left')
            ->where($this->db->dbprefix('deposits').'.company_id', $company_id)
            ->add_column("Actions", "<div class=\"text-center\"><a class=\"tip\" title='" . lang("deposit_note") . "' href='" . admin_url('customers/deposit_note/$1') . "' data-toggle='modal' data-target='#myModal2'><i class=\"fa fa-file-text-o\"></i></a> <a class=\"tip\" title='" . lang("edit_deposit") . "' href='" . admin_url('customers/edit_deposit/$1') . "' data-toggle='modal' data-target='#myModal2'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_deposit") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('customers/delete_deposit/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id")
        ->unset_column('id');
        echo $this->datatables->generate();
    }

    function add_deposit($company_id = NULL)
    {
        $this->sma->checkPermissions('deposits', true);

        if ($this->input->get('id')) {
            $company_id = $this->input->get('id');
        }
        $company = $this->companies_model->getCompanyByID($company_id);

        if ($this->Owner || $this->Admin) {
            $this->form_validation->set_rules('date', lang("date"), 'required');
        }
        $this->form_validation->set_rules('amount', lang("amount"), 'required|numeric');

        if ($this->form_validation->run() == true) {

            if ($this->Owner || $this->Admin) {
                $date = $this->sma->fld(trim($this->input->post('date')));
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $data = array(
                'date' => $date,
                'amount' => $this->input->post('amount'),
                'paid_by' => $this->input->post('paid_by'),
                'note' => $this->input->post('note'),
                'company_id' => $company->id,
                'created_by' => $this->session->userdata('user_id'),
            );

            $cdata = array(
                'deposit_amount' => ($company->deposit_amount+$this->input->post('amount'))
            );

        } elseif ($this->input->post('add_deposit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('customers');
        }

        if ($this->form_validation->run() == true && $this->companies_model->addDeposit($data, $cdata)) {
            $this->session->set_flashdata('message', lang("deposit_added"));
            admin_redirect("customers");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['company'] = $company;
            $this->load->view($this->theme . 'customers/add_deposit', $this->data);
        }
    }

    function edit_deposit($id = NULL)
    {
        $this->sma->checkPermissions('deposits', true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        $deposit = $this->companies_model->getDepositByID($id);
        $company = $this->companies_model->getCompanyByID($deposit->company_id);

        if ($this->Owner || $this->Admin) {
            $this->form_validation->set_rules('date', lang("date"), 'required');
        }
        $this->form_validation->set_rules('amount', lang("amount"), 'required|numeric');

        if ($this->form_validation->run() == true) {

            if ($this->Owner || $this->Admin) {
                $date = $this->sma->fld(trim($this->input->post('date')));
            } else {
                $date = $deposit->date;
            }
            $data = array(
                'date' => $date,
                'amount' => $this->input->post('amount'),
                'paid_by' => $this->input->post('paid_by'),
                'note' => $this->input->post('note'),
                'company_id' => $deposit->company_id,
                'updated_by' => $this->session->userdata('user_id'),
                'updated_at' => $date = date('Y-m-d H:i:s'),
            );

            $cdata = array(
                'deposit_amount' => (($company->deposit_amount-$deposit->amount)+$this->input->post('amount'))
            );

        } elseif ($this->input->post('edit_deposit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('customers');
        }

        if ($this->form_validation->run() == true && $this->companies_model->updateDeposit($id, $data, $cdata)) {
            $this->session->set_flashdata('message', lang("deposit_updated"));
            admin_redirect("customers");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['company'] = $company;
            $this->data['deposit'] = $deposit;
            $this->load->view($this->theme . 'customers/edit_deposit', $this->data);
        }
    }

    public function delete_deposit($id)
    {
        $this->sma->checkPermissions(NULL, TRUE);

        if ($this->companies_model->deleteDeposit($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("deposit_deleted")));
        }
    }

    public function deposit_note($id = null)
    {
        $this->sma->checkPermissions('deposits', true);
        $deposit = $this->companies_model->getDepositByID($id);
        $this->data['customer'] = $this->companies_model->getCompanyByID($deposit->company_id);
        $this->data['deposit'] = $deposit;
        $this->data['page_title'] = $this->lang->line("deposit_note");
        $this->load->view($this->theme . 'customers/deposit_note', $this->data);
    }

    function addresses($company_id = NULL)
    {
        $this->sma->checkPermissions('index', true);
        $this->data['modal_js'] = $this->site->modal_js();
        $this->data['company'] = $this->companies_model->getCompanyByID($company_id);
        $this->data['addresses'] = $this->companies_model->getCompanyAddresses($company_id);
        $this->load->view($this->theme . 'customers/addresses', $this->data);

    }

    function add_address($company_id = NULL)
    {
        $this->sma->checkPermissions('add', true);
        $company = $this->companies_model->getCompanyByID($company_id);

        $this->form_validation->set_rules('line1', lang("line1"), 'required');
        $this->form_validation->set_rules('city', lang("city"), 'required');
        $this->form_validation->set_rules('state', lang("state"), 'required');
        $this->form_validation->set_rules('country', lang("country"), 'required');
        $this->form_validation->set_rules('phone', lang("phone"), 'required');

        if ($this->form_validation->run() == true) {

            $data = array(
                'line1' => $this->input->post('line1'),
                'line2' => $this->input->post('line2'),
                'city' => $this->input->post('city'),
                'postal_code' => $this->input->post('postal_code'),
                'state' => $this->input->post('state'),
                'country' => $this->input->post('country'),
                'phone' => $this->input->post('phone'),
                'company_id' => $company->id,
            );

        } elseif ($this->input->post('add_address')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('customers');
        }

        if ($this->form_validation->run() == true && $this->companies_model->addAddress($data)) {
            $this->session->set_flashdata('message', lang("address_added"));
            admin_redirect("customers");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['company'] = $company;
            $this->load->view($this->theme . 'customers/add_address', $this->data);
        }
    }

    function edit_address($id = NULL)
    {
        $this->sma->checkPermissions('edit', true);

        $this->form_validation->set_rules('line1', lang("line1"), 'required');
        $this->form_validation->set_rules('city', lang("city"), 'required');
        $this->form_validation->set_rules('state', lang("state"), 'required');
        $this->form_validation->set_rules('country', lang("country"), 'required');
        $this->form_validation->set_rules('phone', lang("phone"), 'required');

        if ($this->form_validation->run() == true) {

            $data = array(
                'line1' => $this->input->post('line1'),
                'line2' => $this->input->post('line2'),
                'city' => $this->input->post('city'),
                'postal_code' => $this->input->post('postal_code'),
                'state' => $this->input->post('state'),
                'country' => $this->input->post('country'),
                'phone' => $this->input->post('phone'),
                'updated_at' => date('Y-m-d H:i:s'),
            );

        } elseif ($this->input->post('edit_address')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('customers');
        }

        if ($this->form_validation->run() == true && $this->companies_model->updateAddress($id, $data)) {
            $this->session->set_flashdata('message', lang("address_updated"));
            admin_redirect("customers");
        } else {

            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['address'] = $this->companies_model->getAddressByID($id);
            $this->load->view($this->theme . 'customers/edit_address', $this->data);
        }
    }

    public function delete_address($id)
    {
        $this->sma->checkPermissions('delete', TRUE);

        if ($this->companies_model->deleteAddress($id)) {
            $this->session->set_flashdata('message', lang("address_deleted"));
            admin_redirect("customers");
        }
    }

}
