<?php
namespace PayPal\EBLBaseComponents;

use PayPal\Core\PPXmlMessage;

/**
 * URL to which the customer's browser is returned after
 * choosing to login with PayPal. Required Character length and
 * limitations: no limit.
 */
class SetAuthFlowParamRequestDetailsType
  extends PPXmlMessage
{

    /**
     * URL to which the customer's browser is returned after
     * choosing to login with PayPal. Required Character length and
     * limitations: no limit.
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $ReturnURL;

    /**
     * URL to which the customer is returned if he does not approve
     * the use of PayPal login. Required Character length and
     * limitations: no limit
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $CancelURL;

    /**
     * URL to which the customer's browser is returned after user
     * logs out from PayPal. Required Character length and
     * limitations: no limit.
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $LogoutURL;

    /**
     * The type of the flow. Optional Character length and
     * limitations: 127 single-byte alphanumeric characters
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $InitFlowType;

    /**
     * The used to decide SkipLogin allowed or not. Optional
     * Character length and limitations: 127 single-byte
     * alphanumeric characters
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $SkipLoginPage;

    /**
     * The name of the field Merchant requires from PayPal after
     * user's login. Optional Character length and limitations: 256
     * single-byte alphanumeric characters
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $ServiceName1;

    /**
     * Whether the field is required, opt-in or opt-out.  Optional
     * Character length and limitations: 127 single-byte
     * alphanumeric characters
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $ServiceDefReq1;

    /**
     * The name of the field Merchant requires from PayPal after
     * user's login. Optional Character length and limitations: 256
     * single-byte alphanumeric characters
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $ServiceName2;

    /**
     * Whether the field is required, opt-in or opt-out. Optional
     * Character length and limitations: 127 single-byte
     * alphanumeric characters
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $ServiceDefReq2;

    /**
     * Locale of pages displayed by PayPal during Authentication
     * Login. Optional Character length and limitations: Five
     * single-byte alphabetic characters, upper- or lowercase.
     * Allowable values: AU or en_AUDE or de_DEFR or fr_FRGB or
     * en_GBIT or it_ITJP or ja_JPUS or en_US
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $LocaleCode;

    /**
     * Sets the Custom Payment Page Style for flow pages associated
     * with this button/link. PageStyle corresponds to the HTML
     * variable page_style for customizing flow pages. The value is
     * the same as the Page Style Name you chose when adding or
     * editing the page style from the Profile subtab of the My
     * Account tab of your PayPal account. Optional Character
     * length and limitations: 30 single-byte alphabetic
     * characters.
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $PageStyle;

    /**
     * A URL for the image you want to appear at the top left of
     * the flow page. The image has a maximum size of 750 pixels
     * wide by 90 pixels high. PayPal recommends that you provide
     * an image that is stored on a secure (https) server. Optional
     * Character length and limitations: 127
     * @access    public
     * @namespace ebl
     * @name cpp -header-image
     * @var string
     */
    public $cppheaderimage;

    /**
     * Sets the border color around the header of the flow page.
     * The border is a 2-pixel perimeter around the header space,
     * which is 750 pixels wide by 90 pixels high. Optional
     * Character length and limitations: Six character HTML
     * hexadecimal color code in ASCII
     * @access    public
     * @namespace ebl
     * @name cpp -header-border-color
     * @var string
     */
    public $cppheaderbordercolor;

    /**
     * Sets the background color for the header of the flow page.
     * Optional Character length and limitation: Six character HTML
     * hexadecimal color code in ASCII
     * @access    public
     * @namespace ebl
     * @name cpp -header-back-color
     * @var string
     */
    public $cppheaderbackcolor;

    /**
     * Sets the background color for the payment page. Optional
     * Character length and limitation: Six character HTML
     * hexadecimal color code in ASCII
     * @access    public
     * @namespace ebl
     * @name cpp -payflow-color
     * @var string
     */
    public $cpppayflowcolor;

    /**
     * First Name of the user, this information is used if user
     * chooses to signup with PayPal. Optional Character length and
     * limitation: Six character HTML hexadecimal color code in
     * ASCII
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $FirstName;

    /**
     * Last Name of the user, this information is used if user
     * chooses to signup with PayPal. Optional Character length and
     * limitation: Six character HTML hexadecimal color code in
     * ASCII
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $LastName;

    /**
     * User address, this information is used when user chooses to
     * signup for PayPal. Optional If you include a shipping
     * address and set the AddressOverride element on the request,
     * PayPal returns this same address in
     * GetExpressCheckoutDetailsResponse.
     * @access    public
     * @namespace ebl
     * @var \PayPal\EBLBaseComponents\AddressType
     */
    public $Address;

}
