<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Transaction_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

	public function addTransaction($data,$sale)
    { 
		
		$data['sale_id'] = $sale;
		if ($this->db->insert('transaction', $data))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	public function addTransa($data)
    { 
		if ($this->db->insert('transaction', $data))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	
	public function addTransaction_Purchase($data,$sale)
    { 
		$data['purchase_id'] = $sale;
		if ($this->db->insert('transaction', $data))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	
	public function updateSale($id,$data)
    { 
		if ($this->db->update('transaction', $data, array('sale_id' => $id)))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	
	public function updatePurchase($id,$data)
    { 
		if ($this->db->update('transaction', $data, array('purchase_id' => $id)))
		{
			$transaction_id = $this->db->insert_id();
			return true;
        }
        return FALSE;
    }
	
	public function getAllTransaction()
    {
        $q = $this->db->get('transaction');
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
	
	public function getAllTransactionByID($id)
    {
		$q = $this->db->get_where('transaction', array('id' => $id), 1);
		if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }
	
	
	public function deleteTransaction($id)
    {
        if ($this->db->delete('transaction', array('id' => $id))) 
		{
            /*$this->db->delete('transaction', array('product_id' => $id));
            $this->db->delete('product_variants', array('product_id' => $id));
            $this->db->delete('product_photos', array('product_id' => $id));
            $this->db->delete('product_prices', array('product_id' => $id));*/
            return true;
        }
        return FALSE;
    }
	
	public function addAccount($data)
    {
        if ($this->db->insert('accounts', $data)) 
		{
            $account_id = $this->db->insert_id();

			return true;
        }
        return false;

    }
	public function getAllAccount()
    {
        $q = $this->db->get('accounts');
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				
                $data[] = $row;
            
			}
			return $data;
        }
        return FALSE;
    }
	
	public function getAllAccounts()
    {
        $q = $this->db->get('accounts');
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				if(($row->account_category ==2)||($row->account_category==6))
				{
					$data[] = $row;
				}
			}
			return $data;
        }
        return FALSE;
    }
	
	public function getAllCateType() 
	{
        $q = $this->db->get("accounts");
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				if(($row->belongs_to ==1)||($row->belongs_to==3))
				{
					$data[] = $row;
				}
			}
            return $data;
        }
        return FALSE;
    }
	public function getCateType() 
	{
        $q = $this->db->get("accounts");
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row) 
			{
				if(($row->belongs_to ==2)||($row->belongs_to==3))
				{
					$data[] = $row;
				}
			}
            return $data;
        }
        return FALSE;
    }
	
	public function updateAccount($id,$data)
    {
        if ($this->db->update('accounts', $data, array('id' => $id))) 
		{
            $account_ids = $this->db->insert_id();

			return true;
        }
        return false;

    }
	
	public function getAllAccountByID($id) 
	{
        $q = $this->db->get_where('accounts', array('id' => $id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }
	
	public function getAllAccountByType($types) 
	{
		$q = $this->db->get_where('accounts', array('type' => $types), 1);
		if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
		
        return FALSE;
    }
	
	public function deleteAccount($id)
    {
        if ($this->db->delete('accounts', array('id' => $id))) {
            /*$this->db->delete('transaction', array('product_id' => $id));
            $this->db->delete('product_variants', array('product_id' => $id));
            $this->db->delete('product_photos', array('product_id' => $id));
            $this->db->delete('product_prices', array('product_id' => $id));*/
            return true;
        }
        return FALSE;
    }
	
	
	public function addStatement($start_date,$end_date,$Account) 
	{ 
		$this->db->where("date <=", $end_date);
        $this->db->where("date >=", $start_date);
		$this->db->where("account", $Account);
		$q = $this->db->get('transaction');
		if ($q->num_rows() > 0) 
		{
           foreach (($q->result()) as $row) 
		   {
                $data[] = $row;
           }
           return $data;
        }
        return array();
    }
 public function getTrandByName($name)
    {
        $q = $this->db->get_where('type', array('name' => $name), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function addType($data)
    {
        if ($this->db->insert("type", $data)) 
		{
            return true;
        }
        return false;
    }

    public function addTypes($data)
    {
        if ($this->db->insert_batch('type', $data)) 
		{
            return true;
        }
        return false;
    }

    public function updateType($id, $data = array())
    {
        if ($this->db->update("type", $data, array('id' => $id))) 
		{
            return true;
        }
        return false;
    }

    public function typeHasTransaction($brand_id)
    {
        $q = $this->db->get_where('transaction', array('type' => $type_id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function deleteType($id)
    {
        if ($this->db->delete("type", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
	
	public function getTransactionCategoryByID($id)
    {
        $q = $this->db->get_where("transaction_categories", array('id' => $id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function getTransactionCategoryByCode($code)
    {
        $q = $this->db->get_where("transaction_categories", array('code' => $code), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function addTransactionCategory($data)
    {
        if ($this->db->insert("transaction_categories", $data)) 
		{
            return true;
        }
        return false;
    }

    public function addTransactionCategories($data)
    {
        if ($this->db->insert_batch("transaction_categories", $data)) 
		{
            return true;
        }
        return false;
    }

    public function updateTransactionCategory($id, $data = array())
    {
        if ($this->db->update("transaction_categories", $data, array('id' => $id))) 
		{
            return true;
        }
        return false;
    }

    public function hasTransactionCategoryRecord($id)
    {
        $this->db->where('id', $id);
        return $this->db->count_all_results('transaction');
    }

    public function deleteTransactionCategory($id)
    {
        if ($this->db->delete("transaction_categories", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
	public function deleteCategory($id)
    {
        if ($this->db->delete("transaction_categories", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
	public function getAccountCategoryByName($name)
    {
        $q = $this->db->get_where('account_category', array('name' => $name), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function addAccountCategory($data)
    {
        if ($this->db->insert("account_category", $data)) 
		{
            return true;
        }
        return false;
    }

    public function addAccountCategories($data)
    {
        if ($this->db->insert_batch('type', $data)) 
		{
            return true;
        }
        return false;
    }

    public function updateAccountCategory($id, $data = array())
    {
        if ($this->db->update("account_category", $data, array('id' => $id))) 
		{
            return true;
        }
        return false;
    }

    public function AccountCategoryHasTransaction($brand_id)
    {
        $q = $this->db->get_where('transaction', array('account_category' => $account_category_id), 1);
        if ($q->num_rows() > 0) 
		{
            return $q->row();
        }
        return FALSE;
    }

    public function deleteAccountCategory($id)
    {
        if ($this->db->delete("account_category", array('id' => $id))) 
		{
            return true;
        }
        return FALSE;
    }
  public function getAllAccountCategory()
    {
        $q = $this->db->get('account_category');
		
        if ($q->num_rows() > 0) 
		{
            foreach (($q->result()) as $row)
			{
                $data[] = $row;
            } 
			return $data;
        }
        return FALSE;
    }
  
  
}
