<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* Vulnerability File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\SecurityNamespace\Model;

/**
* Vulnerability class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class Vulnerability extends \Beta\Microsoft\Graph\Model\Entity
{
    /**
    * Gets the activeExploitsObserved
    * Indicates whether this vulnerability has any known exploits associated to known bad actors.
    *
    * @return bool|null The activeExploitsObserved
    */
    public function getActiveExploitsObserved()
    {
        if (array_key_exists("activeExploitsObserved", $this->_propDict)) {
            return $this->_propDict["activeExploitsObserved"];
        } else {
            return null;
        }
    }

    /**
    * Sets the activeExploitsObserved
    * Indicates whether this vulnerability has any known exploits associated to known bad actors.
    *
    * @param bool $val The activeExploitsObserved
    *
    * @return Vulnerability
    */
    public function setActiveExploitsObserved($val)
    {
        $this->_propDict["activeExploitsObserved"] = boolval($val);
        return $this;
    }

    /**
    * Gets the commonWeaknessEnumerationIds
    * Community-defined common weakness enumerations (CWE).
    *
    * @return array|null The commonWeaknessEnumerationIds
    */
    public function getCommonWeaknessEnumerationIds()
    {
        if (array_key_exists("commonWeaknessEnumerationIds", $this->_propDict)) {
            return $this->_propDict["commonWeaknessEnumerationIds"];
        } else {
            return null;
        }
    }

    /**
    * Sets the commonWeaknessEnumerationIds
    * Community-defined common weakness enumerations (CWE).
    *
    * @param string[] $val The commonWeaknessEnumerationIds
    *
    * @return Vulnerability
    */
    public function setCommonWeaknessEnumerationIds($val)
    {
        $this->_propDict["commonWeaknessEnumerationIds"] = $val;
        return $this;
    }

    /**
    * Gets the createdDateTime
    * The date and time when this vulnerability article was first created.
    *
    * @return \DateTime|null The createdDateTime
    */
    public function getCreatedDateTime()
    {
        if (array_key_exists("createdDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["createdDateTime"], "\DateTime") || is_null($this->_propDict["createdDateTime"])) {
                return $this->_propDict["createdDateTime"];
            } else {
                $this->_propDict["createdDateTime"] = new \DateTime($this->_propDict["createdDateTime"]);
                return $this->_propDict["createdDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the createdDateTime
    * The date and time when this vulnerability article was first created.
    *
    * @param \DateTime $val The createdDateTime
    *
    * @return Vulnerability
    */
    public function setCreatedDateTime($val)
    {
        $this->_propDict["createdDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the cvss2Summary
    * A summary of the common vulnerability scoring system (v2) findings about this vulnerability.
    *
    * @return CvssSummary|null The cvss2Summary
    */
    public function getCvss2Summary()
    {
        if (array_key_exists("cvss2Summary", $this->_propDict)) {
            if (is_a($this->_propDict["cvss2Summary"], "\Beta\Microsoft\Graph\SecurityNamespace\Model\CvssSummary") || is_null($this->_propDict["cvss2Summary"])) {
                return $this->_propDict["cvss2Summary"];
            } else {
                $this->_propDict["cvss2Summary"] = new CvssSummary($this->_propDict["cvss2Summary"]);
                return $this->_propDict["cvss2Summary"];
            }
        }
        return null;
    }

    /**
    * Sets the cvss2Summary
    * A summary of the common vulnerability scoring system (v2) findings about this vulnerability.
    *
    * @param CvssSummary $val The cvss2Summary
    *
    * @return Vulnerability
    */
    public function setCvss2Summary($val)
    {
        $this->_propDict["cvss2Summary"] = $val;
        return $this;
    }

    /**
    * Gets the cvss3Summary
    * A summary of the common vulnerability scoring system (v3) findings about this vulnerability.
    *
    * @return CvssSummary|null The cvss3Summary
    */
    public function getCvss3Summary()
    {
        if (array_key_exists("cvss3Summary", $this->_propDict)) {
            if (is_a($this->_propDict["cvss3Summary"], "\Beta\Microsoft\Graph\SecurityNamespace\Model\CvssSummary") || is_null($this->_propDict["cvss3Summary"])) {
                return $this->_propDict["cvss3Summary"];
            } else {
                $this->_propDict["cvss3Summary"] = new CvssSummary($this->_propDict["cvss3Summary"]);
                return $this->_propDict["cvss3Summary"];
            }
        }
        return null;
    }

    /**
    * Sets the cvss3Summary
    * A summary of the common vulnerability scoring system (v3) findings about this vulnerability.
    *
    * @param CvssSummary $val The cvss3Summary
    *
    * @return Vulnerability
    */
    public function setCvss3Summary($val)
    {
        $this->_propDict["cvss3Summary"] = $val;
        return $this;
    }

    /**
    * Gets the description
    * The vulnerability article contents, describing the vulnerability.
    *
    * @return FormattedContent|null The description
    */
    public function getDescription()
    {
        if (array_key_exists("description", $this->_propDict)) {
            if (is_a($this->_propDict["description"], "\Beta\Microsoft\Graph\SecurityNamespace\Model\FormattedContent") || is_null($this->_propDict["description"])) {
                return $this->_propDict["description"];
            } else {
                $this->_propDict["description"] = new FormattedContent($this->_propDict["description"]);
                return $this->_propDict["description"];
            }
        }
        return null;
    }

    /**
    * Sets the description
    * The vulnerability article contents, describing the vulnerability.
    *
    * @param FormattedContent $val The description
    *
    * @return Vulnerability
    */
    public function setDescription($val)
    {
        $this->_propDict["description"] = $val;
        return $this;
    }


     /**
     * Gets the exploits
    * Known exploits for this vulnerability.
     *
     * @return array|null The exploits
     */
    public function getExploits()
    {
        if (array_key_exists("exploits", $this->_propDict)) {
           return $this->_propDict["exploits"];
        } else {
            return null;
        }
    }

    /**
    * Sets the exploits
    * Known exploits for this vulnerability.
    *
    * @param Hyperlink[] $val The exploits
    *
    * @return Vulnerability
    */
    public function setExploits($val)
    {
        $this->_propDict["exploits"] = $val;
        return $this;
    }

    /**
    * Gets the exploitsAvailable
    * Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
    *
    * @return bool|null The exploitsAvailable
    */
    public function getExploitsAvailable()
    {
        if (array_key_exists("exploitsAvailable", $this->_propDict)) {
            return $this->_propDict["exploitsAvailable"];
        } else {
            return null;
        }
    }

    /**
    * Sets the exploitsAvailable
    * Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
    *
    * @param bool $val The exploitsAvailable
    *
    * @return Vulnerability
    */
    public function setExploitsAvailable($val)
    {
        $this->_propDict["exploitsAvailable"] = boolval($val);
        return $this;
    }

    /**
    * Gets the hasChatter
    * Indicates whether chatter about this vulnerability has been discovered online.
    *
    * @return bool|null The hasChatter
    */
    public function getHasChatter()
    {
        if (array_key_exists("hasChatter", $this->_propDict)) {
            return $this->_propDict["hasChatter"];
        } else {
            return null;
        }
    }

    /**
    * Sets the hasChatter
    * Indicates whether chatter about this vulnerability has been discovered online.
    *
    * @param bool $val The hasChatter
    *
    * @return Vulnerability
    */
    public function setHasChatter($val)
    {
        $this->_propDict["hasChatter"] = boolval($val);
        return $this;
    }

    /**
    * Gets the lastModifiedDateTime
    * The date and time when this vulnerability article was most recently updated.
    *
    * @return \DateTime|null The lastModifiedDateTime
    */
    public function getLastModifiedDateTime()
    {
        if (array_key_exists("lastModifiedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastModifiedDateTime"], "\DateTime") || is_null($this->_propDict["lastModifiedDateTime"])) {
                return $this->_propDict["lastModifiedDateTime"];
            } else {
                $this->_propDict["lastModifiedDateTime"] = new \DateTime($this->_propDict["lastModifiedDateTime"]);
                return $this->_propDict["lastModifiedDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastModifiedDateTime
    * The date and time when this vulnerability article was most recently updated.
    *
    * @param \DateTime $val The lastModifiedDateTime
    *
    * @return Vulnerability
    */
    public function setLastModifiedDateTime($val)
    {
        $this->_propDict["lastModifiedDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the priorityScore
    * A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
    *
    * @return int|null The priorityScore
    */
    public function getPriorityScore()
    {
        if (array_key_exists("priorityScore", $this->_propDict)) {
            return $this->_propDict["priorityScore"];
        } else {
            return null;
        }
    }

    /**
    * Sets the priorityScore
    * A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
    *
    * @param int $val The priorityScore
    *
    * @return Vulnerability
    */
    public function setPriorityScore($val)
    {
        $this->_propDict["priorityScore"] = intval($val);
        return $this;
    }

    /**
    * Gets the publishedDateTime
    * The date and time when this vulnerability article was published.
    *
    * @return \DateTime|null The publishedDateTime
    */
    public function getPublishedDateTime()
    {
        if (array_key_exists("publishedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["publishedDateTime"], "\DateTime") || is_null($this->_propDict["publishedDateTime"])) {
                return $this->_propDict["publishedDateTime"];
            } else {
                $this->_propDict["publishedDateTime"] = new \DateTime($this->_propDict["publishedDateTime"]);
                return $this->_propDict["publishedDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the publishedDateTime
    * The date and time when this vulnerability article was published.
    *
    * @param \DateTime $val The publishedDateTime
    *
    * @return Vulnerability
    */
    public function setPublishedDateTime($val)
    {
        $this->_propDict["publishedDateTime"] = $val;
        return $this;
    }


     /**
     * Gets the references
    * Reference links where further information can be learned about this vulnerability.
     *
     * @return array|null The references
     */
    public function getReferences()
    {
        if (array_key_exists("references", $this->_propDict)) {
           return $this->_propDict["references"];
        } else {
            return null;
        }
    }

    /**
    * Sets the references
    * Reference links where further information can be learned about this vulnerability.
    *
    * @param Hyperlink[] $val The references
    *
    * @return Vulnerability
    */
    public function setReferences($val)
    {
        $this->_propDict["references"] = $val;
        return $this;
    }

    /**
    * Gets the remediation
    * Any known remediation steps.
    *
    * @return FormattedContent|null The remediation
    */
    public function getRemediation()
    {
        if (array_key_exists("remediation", $this->_propDict)) {
            if (is_a($this->_propDict["remediation"], "\Beta\Microsoft\Graph\SecurityNamespace\Model\FormattedContent") || is_null($this->_propDict["remediation"])) {
                return $this->_propDict["remediation"];
            } else {
                $this->_propDict["remediation"] = new FormattedContent($this->_propDict["remediation"]);
                return $this->_propDict["remediation"];
            }
        }
        return null;
    }

    /**
    * Sets the remediation
    * Any known remediation steps.
    *
    * @param FormattedContent $val The remediation
    *
    * @return Vulnerability
    */
    public function setRemediation($val)
    {
        $this->_propDict["remediation"] = $val;
        return $this;
    }

    /**
    * Gets the severity
    * Indicates the severity of this vulnerability. The possible values are: none, low, medium, high, critical, unknownFutureValue.
    *
    * @return VulnerabilitySeverity|null The severity
    */
    public function getSeverity()
    {
        if (array_key_exists("severity", $this->_propDict)) {
            if (is_a($this->_propDict["severity"], "\Beta\Microsoft\Graph\SecurityNamespace\Model\VulnerabilitySeverity") || is_null($this->_propDict["severity"])) {
                return $this->_propDict["severity"];
            } else {
                $this->_propDict["severity"] = new VulnerabilitySeverity($this->_propDict["severity"]);
                return $this->_propDict["severity"];
            }
        }
        return null;
    }

    /**
    * Sets the severity
    * Indicates the severity of this vulnerability. The possible values are: none, low, medium, high, critical, unknownFutureValue.
    *
    * @param VulnerabilitySeverity $val The severity
    *
    * @return Vulnerability
    */
    public function setSeverity($val)
    {
        $this->_propDict["severity"] = $val;
        return $this;
    }


     /**
     * Gets the articles
    * Articles related to this vulnerability.
     *
     * @return array|null The articles
     */
    public function getArticles()
    {
        if (array_key_exists("articles", $this->_propDict)) {
           return $this->_propDict["articles"];
        } else {
            return null;
        }
    }

    /**
    * Sets the articles
    * Articles related to this vulnerability.
    *
    * @param Article[] $val The articles
    *
    * @return Vulnerability
    */
    public function setArticles($val)
    {
        $this->_propDict["articles"] = $val;
        return $this;
    }


     /**
     * Gets the components
    * Components related to this vulnerability article.
     *
     * @return array|null The components
     */
    public function getComponents()
    {
        if (array_key_exists("components", $this->_propDict)) {
           return $this->_propDict["components"];
        } else {
            return null;
        }
    }

    /**
    * Sets the components
    * Components related to this vulnerability article.
    *
    * @param VulnerabilityComponent[] $val The components
    *
    * @return Vulnerability
    */
    public function setComponents($val)
    {
        $this->_propDict["components"] = $val;
        return $this;
    }

}
