<?php

namespace Workdo\LandingPage\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Workdo\LandingPage\Entities\LandingPageSetting;

class LandingPageDataTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        // $this->call("OthersTableSeeder");

        $data['menubar_status'] = 'on';
        $data['menubar_page'] = '[{"template_name":"page_content","page_url":"","menubar_page_contant":"<p>At WorkDo our vision is to become a one-stop destination for all your IT needs by creating disruptive web solutions that remain accessible to all. We diligently work towards bringing our clients IT solutions that transform the way their businesses function. Rather than confuse you with the complexities of web services we focus on bringing our clients simplified web solutions. From Web development, to Web maintenance, we are dedicated to making your IT life easier.<\/p>","login":"on","menubar_page_name":"About Us","menubar_page_short_description":"WorkDo offers comprehensive web solutions to businesses. We aim to provide products that are beautifully designed, user friendly and a delight to use.","page_slug":"about_us","header":"on","footer":"on"}]';
        $data['site_logo'] = 'site_logo.png';
        $data['home_status'] = 'on';
        $data['home_offer_text'] = '70% Special Offer1';
        $data['home_title'] = 'Home';
        $data['home_heading'] = 'With Dash, you can take care of each need of your business functions in.one place';
        $data['home_description'] = 'Lay a solid foundation for your brand. Grab a high-converting web powered by a secure backend coupled with an intuitive eCommerce.';
        $data['home_trusted_by'] = 'Our best partners and +11,000 customers worldwide satisfied with our services.';
        $data['home_live_demo_link'] = 'https://dash-demo.workdo.io/login';
        $data['home_banner'] = 'home_banner.png';
        $data['home_logo'] = 'home_logo.png';
        $data['home_link_button_text'] = 'View Live Demo';
        $data['feature_status'] = 'on';
        $data['feature_title'] = 'Features';
        $data['feature_of_features'] = '[{"feature_logo":"1690960676-feature_logo.png","feature_heading":"Free & Open Source","feature_description":"<p>Give your customers a quick way to find the products they want. Thanks to a built-in, intuitive search and filtering, they can view only those products that they&rsquo;re interested in.<\/p>","feature_more_details_link":"#","feature_more_details_button_text":"Find Out More"},{"feature_logo":"1690960805-feature_logo.png","feature_heading":"Guaranteed to Grow Your Business","feature_description":"<p>Give your customers a quick way to find the products they want. Thanks to a built-in, intuitive search and filtering, they can view only those products that they\u2019re interested in.<\/p>","feature_more_details_link":"#","feature_more_details_button_text":"Find Out More"},{"feature_logo":"1690960837-feature_logo.png","feature_heading":"24\/7 Support","feature_description":"<p>Give your customers a quick way to find the products they want. Thanks to a built-in, intuitive search and filtering, they can view only those products that they&rsquo;re interested in.<\/p>","feature_more_details_link":"#","feature_more_details_button_text":"Find Out More"}]';
        $data['highlight_feature_heading'] = 'Why choose dedicated modules for Your Business?';
        $data['highlight_feature_description'] = 'With Dash, you can conveniently manage all your business functions from a single location.';
        $data['highlight_feature_image'] = '';
        $data['other_features'] = '[{"other_features_image":"1690961114-other_features_image.png","other_features_tag":"SALES","other_features_heading":"Account Helps You Simplify Your Accounting and Billing","other_featured_description":"Manage your billing and accounting without little to no effort! Set financial goals and let the system monitor them for you, automate taxes, and more! - without lifting a finger.","other_feature_buy_now_link":null,"cards":{"1":{"title":"Simplify Your Accounting and Billing","description":"Simplify your accounting and make it easy to keep an eye on your money. Set financial goals and let the system monitor them for you, automate taxes, and more! - without lifting a finger."},"2":{"title":"Take Control Of Your Inventory","description":"Save time by managing your entire inventory with a few clicks. Easily create categories and add products to them. Modify product prices whenever you want, assign SKUs, create different tax rates, and do so much more!"},"3":{"title":"Take Your Project from Proposal to Payment","description":"Land new clients in a flash, and get paid just as fast. Create proposal templates and pitch your future clients. Turn your accepted proposals into payable invoices, send reminders, and get paid fast - all in one place!"}}},{"other_features_image":"1690961251-other_features_image.png","other_features_tag":"SALES","other_features_heading":"Everything You Need For a Successful HRM - In One Place","other_featured_description":"<p>This feature makes it easier for a company to maintain a record of an employee&rsquo;s personal, company, and Bank details along with their essential documentation. Employees could view and manage their profiles.<\/p>","other_feature_buy_now_link":null,"cards":{"1":{"title":"Manage Key Employee Matters Easily","description":"Create a profile for every employee, track their key information, and update the information in just a few clicks. Collect and analyze feedback about their work, including warnings and complaints issued by their managers or other employees."},"2":{"title":"Help Your Employees Become More Productive","description":"Empower employee growth. Schedule skills training, track expenses, and watch your employees become better at their work. Boost employee productivity with custom KPIs. Track employee performance, share feedback, and help them reach company targets."},"3":{"title":"Manage Payroll in Just a Few Clicks","description":"Pay your employees for their hard work. Keep data of all workforce costs, transfers, deposits, and other employee-related transactions for future reference. Track employee attendance and overtime to ensure they always receive fair compensation for their work."}}},{"other_features_image":"1690961340-other_features_image.png","other_features_tag":"SALES","other_features_heading":"Easily manage all your projects and keep your business growing.","other_featured_description":"<p>Got a big team or working on multiple projects at once? Manage task priorities or even create additional workspaces and use the built-in permission system to separate core projects. Make your team more effective by helping them avoid confusion ensuring they always know what to focus on.<\/p>","other_feature_buy_now_link":null,"cards":{"1":{"title":"Kanban Task Management","description":"Whether you need a simple tool to track your tasks, are a Kanban fan, want to create Gantt Charts or are looking for a convenient tool to track your projects - Taskly got you covered."},"2":{"title":"Creating milestones and assigning subtasks","description":"Add a new task to an already existing project and prioritize them according to the need of urgency. Assign the task to team members and set a due date for task completion. Add comments to the task and create a sub-task for ease of completion. Attach necessary files in a required task."},"3":{"title":"Bugs Resolution","description":"Create new bugs and assign users and priority to them. You can write a note in the text box for the bug description. Also, the status of each bug could be changed through an easy drop-down and Kanban drag system."}}},{"other_features_image":"1690961430-other_features_image.png","other_features_tag":"SALES","other_features_heading":"Manage Your Leads Better. Convert Faster.","other_featured_description":"<p>Skyrocket your sales with an effective lead management tool. Determine the value of leads and develop promising leads with ease. Get clearer action plans and make smarter and well-informed decisions.<\/p>","other_feature_buy_now_link":null,"cards":{"1":{"title":"Manage All Your Leads Under One Roof","description":"Manage your clients, users, and deals from anywhere, and from a single tab. Access a wide range of features, get a graphical representation of your data, and make informed decisions."},"2":{"title":"Cost-Efficient Lead Management","description":"Save money and manage your time effectively to improve your business productivity. Automate your lead management and start closing more deals and making more sales on autopilot."},"3":{"title":"Get Tailored Reports","description":"Easily measure every aspect of your business from an intuitive interface. Generate insights that lead to more effective sales, and manage your leads and deals with a smooth drag-and-drop system."}}},{"other_features_image":"1690961507-other_features_image.png","other_features_tag":"SALES","other_features_heading":"Ease in maintaining customer and vendor details","other_featured_description":"<p>POS allows you to create and maintain the data of each customer and vendor. You get access to all essential information through a well-maintained format.<\/p>","other_feature_buy_now_link":null,"cards":{"1":{"title":"Manage vital information from one dashboard","description":"Stay on top of your total and monthly purchases and sales. Get an interactive purchase and sales report graph to help you make informed decisions. Get progress reports of each branch, along with to-do lists and event calendars."},"2":{"title":"Set your sales targets and achieve them faster","description":"Create sales targets and keep track of their progress in your dashboard. Use the expense list to cut down on unnecessary expenses, and put more resources into reaching your sales targets."},"3":{"title":"Manage your products with ease","description":"Never stress about managing your inventory ever again! With PosGo, you can create your products and assign them a brand, category, unit and tax rate. You can even modify product descriptions, images, and price whenever you want."}}}]';
        $data['screenshots_status'] = 'on';
        $data['screenshots'] = '[{"screenshots":"1690966361-screenshots.png","screenshots_heading":"Project"},{"screenshots":"1690966398-screenshots.png","screenshots_heading":"POS"},{"screenshots":"1690966421-screenshots.png","screenshots_heading":"CRM"},{"screenshots":"1690966443-screenshots.png","screenshots_heading":"Accounting"},{"screenshots":"1690966482-screenshots.png","screenshots_heading":"HRM"}]';
        $data['footer_status'] = 'on';
        $data['joinus_status'] = 'on';
        $data['joinus_heading'] = 'Join Our Community';
        $data['joinus_description'] = 'We build modern web tools to help you jump-start your daily business work.';
        $data['footer_logo'] = '1690967309-footer_logo.png';
        $data['footer_description'] = 'We build modern web tools to help you jump-start your daily business work.';
        $data['footer_live_demo_link'] = '#';
        $data['all_rights_reserve_text'] = 'All Rights Reserved to';
        $data['footer_support_link'] = '#';
        $data['all_rights_reserve_website_name'] = 'workdo.io';
        $data['all_rights_reserve_website_url'] = 'https://www.workdo.io';
        $data['footer_sections_details'] = '[{"footer_section_heading":"Company","footer_section_text":{"1":{"title":"About Us","link":"#"},"2":{"title":"Freebies","link":"#"},"3":{"title":"Premium","link":"#"},"4":{"title":"Blog","link":"#"},"5":{"title":"Affiliate Program","link":"#"},"6":{"title":"Get coupon","link":"#"}}},{"footer_section_heading":"Help and Support","footer_section_text":{"1":{"title":"Knowledge Center","link":"#"},"2":{"title":"Contact Us","link":"#"},"3":{"title":"Premium Support","link":"#"},"4":{"title":"Sponsorships","link":"#"},"5":{"title":"Custom Development","link":"#"}}},{"footer_section_heading":"Help and Support","footer_section_text":{"1":{"title":"Terms & Conditions","link":"#"},"2":{"title":"Privacy Policy","link":"#"},"3":{"title":"Licenses","link":"#"}}}]';
        $data['footer_gotoshop_button_text'] = 'Go to Shop';
        $data['footer_support_button_text'] = 'Support';
        $data['reviews'] = '[{"review_header_tag":"SOLID FOUNDATION","review_heading":"A style theme, together with a dedicated Laravel backend and an intuitive mobile app","review_description":"<p>gives your business an unfair advantage. The package doesn\u2019t just provide you with everything you need to start selling online. It gives you a solid foundation for an eCommerce business for years to come.<\/p>","review_live_demo_link":"https:\/\/dash-demo.workdo.io\/login","review_live_demo_button_text":"View Live Demo"},{"review_header_tag":"SOLID FOUNDATION","review_heading":"A style theme, together with a dedicated Laravel backend and an intuitive mobile app","review_description":"<p>gives your business an unfair advantage. The package doesn\u2019t just provide you with everything you need to start selling online. It gives you a solid foundation for an eCommerce business for years to come.<\/p>","review_live_demo_link":"https:\/\/dash-demo.workdo.io\/login","review_live_demo_button_text":"View Live Demo"},{"review_header_tag":"SOLID FOUNDATION","review_heading":"A style theme, together with a dedicated Laravel backend and an intuitive mobile app","review_description":"<p>gives your business an unfair advantage. The package doesn\u2019t just provide you with everything you need to start selling online. It gives you a solid foundation for an eCommerce business for years to come.<\/p>","review_live_demo_link":"https:\/\/dash-demo.workdo.io\/login","review_live_demo_button_text":"View Live Demo"},{"review_header_tag":"SOLID FOUNDATION","review_heading":"A style theme, together with a dedicated Laravel backend and an intuitive mobile app","review_description":"<p>gives your business an unfair advantage. The package doesn\u2019t just provide you with everything you need to start selling online. It gives you a solid foundation for an eCommerce business for years to come.<\/p>","review_live_demo_link":"https:\/\/dash-demo.workdo.io\/login","review_live_demo_button_text":"View Live Demo"},{"review_header_tag":"SOLID FOUNDATION","review_heading":"A style theme, together with a dedicated Laravel backend and an intuitive mobile app","review_description":"gives your business an unfair advantage. The package doesn\u2019t just provide you with everything you need to start selling online. It gives you a solid foundation for an eCommerce business for years to come.","review_live_demo_link":"https:\/\/dash-demo.workdo.io\/login","review_live_demo_button_text":"View Live Demo"}]';

        $data['dedicated_heading'] = 'Why Choose a Dedicated Fashion Theme for Your Business?';
        $data['dedicated_description'] = 'With Alligō, you can take care of the entire partner lifecycle - from onboarding through nurturing, cooperating, and rewarding. Find top performers and let go of those who arent a good fit.';
        $data['dedicated_live_demo_link'] = 'https://dash-demo.workdo.io/login';
        $data['dedicated_link_button_text'] = 'View Live Demo';
        $data['dedicated_card_details'] = '[{"dedicated_card_logo":"1690966583-dedicated_card_logo.png","dedicated_card_heading":"High-Performing, Secure PHP Framework","dedicated_card_description":"Unlike many frameworks that come and go, the framework stood the test of time. Over the years, it grew to become one of the fastest and most secure frameworks in the market.","dedicated_card_more_details_link":"#","dedicated_card_more_details_button_text":"Find Out More"},{"dedicated_card_logo":"1690966606-dedicated_card_logo.png","dedicated_card_heading":"Stable Codebase","dedicated_card_description":"Some frameworks come and go - but Laravel is here to stay. Laravels active developer community helps keep its codebase up-to-date and stable. This, in turn, helps ensure the stability of your eCommerce website.","dedicated_card_more_details_link":"#","dedicated_card_more_details_button_text":"Find Out more"},{"dedicated_card_logo":"1690966638-dedicated_card_logo.png","dedicated_card_heading":"Secure Integrations","dedicated_card_description":"As you grow, you may want to expand your store with new functionalities or payment methods. Thanks to Laravels flexibility, it\u2019s easy to add new integrations and customize the store even once its already developed.<","dedicated_card_more_details_link":"#","dedicated_card_more_details_button_text":"Find Out more"}]';

        $data['dedicated_section_status'] = 'on';
        $data['buildtech_heading'] = 'Built with Technology You Can Trust';
        $data['buildtech_description'] = 'Our backend is built with Laravel - one of the most popular and highest-rated web development frameworks. Find out why we chose it - and how it benefits your business.';
        $data['buildtech_card_details'] = '[{"buildtech_card_logo":"1690966770-buildtech_card_logo.png","buildtech_card_heading":"Sell More Than Your Competitors","buildtech_card_description":"Your online store has one goal - to sell your products. Thanks to years of experience in the industry, we know the ins and outs of online sales. And we put that knowledge into every package that we offer. With the Style eCommerce package, you get a store that\u2019s optimized for helping you sell more in the fashion niche.","buildtech_card_more_details_link":"#","buildtech_card_more_details_button_text":"Find Out More"},{"buildtech_card_logo":"1690966899-buildtech_card_logo.png","buildtech_card_heading":"Get a Headstart over Your Competitors","buildtech_card_description":"In business, you have to act fast. By choosing our Style theme package, you can get everything you need to start selling right away. Hit the market with your product sooner, attract early sales, and build an audience from day one.","buildtech_card_more_details_link":"#","buildtech_card_more_details_button_text":"Find Out More"},{"buildtech_card_logo":"1690966833-buildtech_card_logo.png","buildtech_card_heading":"Avoid Design Mistakes","buildtech_card_description":"When you get a ready-made package, you avoid common design mistakes that could cost your business a fortune. Not only that. Thanks to a higher conversion rate, you can achieve better ROI on your marketing expenses.","buildtech_card_more_details_link":"#","buildtech_card_more_details_button_text":"Find Out More"},{"buildtech_card_logo":"1690966858-buildtech_card_logo.png","buildtech_card_heading":"Build a Long-Term Asset","buildtech_card_description":"The key to success in eCommerce is to scale your store and build an audience of loyal, recurring customers. With our package, you get more than just a store. You get an asset that\u2019s ready for you to take care of it and grow it for years to come.","buildtech_card_more_details_link":"#","buildtech_card_more_details_button_text":"Find Out More"}]';

        $data['buildtech_section_status'] = 'on';
        $data['packagedetails_section_status'] = 'on';
        $data['packagedetails_heading'] = 'Start an Online Fashion Business with a Complete eCommerce Package';
        $data['packagedetails_short_description'] = 'Get a fashion-themed eCommerce store with a secure backend and convenient mobile app. Build a brand, manage your store wherever you are, and grow an online business.';
        $data['packagedetails_long_description'] = 'An effective fashion theme should be visually appealing and easy to navigate. A good theme makes it easy for customers to find and buy the items they&rsquo;re interested in. The theme should also be responsive so that it looks good on all devices.With the Style theme, you get all of the above - and more. The theme gives you everything you need to sell your products and keep your audience coming back for more. Easily customize the theme and adjust its design to your branding needs. Add products, polish product pages, and start growing your online business.';
        $data['packagedetails_link'] = 'https://dash-demo.workdo.io/dash/pricing';
        $data['packagedetails_button_text'] = 'Get the Package';


        foreach ($data as $key => $value) {
            if (!LandingPageSetting::where('name', '=', $key)->exists()) {
                LandingPageSetting::updateOrCreate(['name' =>  $key], ['value' => $value]);
            }
        }
    }
}
